#
# Cmake package for including the Agar library in a cmake project.
#
# Sets the following variables:
#
#	AGAR_INCLUDE_DIRS
#	AGAR_LIBDIR
#	AGAR_PREFIX
#
#	HAVE_AGAR_CORE  AGAR_CORE_LIBRARIES
#	HAVE_AGAR_GUI   AGAR_GUI_LIBRARIES
#	HAVE_AGAR_AU    AGAR_AU_LIBRARIES
#	HAVE_AGAR_MAP   AGAR_MAP_LIBRARIES
#	HAVE_AGAR_MATH  AGAR_MATH_LIBRARIES
#	HAVE_AGAR_NET   AGAR_NET_LIBRARIES
#	HAVE_AGAR_SG    AGAR_SG_LIBRARIES
#	HAVE_AGAR_SK    AGAR_SK_LIBRARIES
#	HAVE_AGAR_VG    AGAR_VG_LIBRARIES
#

set(propsRelease
	IMPORTED_IMPLIB_RELEASE IMPORTED_IMPLIB_NOCONFIG IMPORTED_IMPLIB IMPORTED_IMPLIB_MINSIZEREL
	IMPORTED_IMPLIB_RELWITHDEBINFO IMPORTED_LOCATION_RELEASE IMPORTED_LOCATION_NOCONFIG
	IMPORTED_LOCATION IMPORTED_LOCATION_MINSIZEREL IMPORTED_LOCATION_RELWITHDEBINFO)

set(propsDebug IMPORTED_IMPLIB_DEBUG IMPORTED_LOCATION_DEBUG)

#
# Agar-Core
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_coreTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_coreTargets.cmake")
	set(HAVE_AGAR_CORE ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_coreStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_coreStaticTargets.cmake")
	set(HAVE_AGAR_CORE ON)
endif()
if(HAVE_AGAR_CORE)
	if(NOT TARGET ag_core::ag_core AND TARGET ag_core::ag_core-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_core::ag_core-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_core::ag_core ALIAS ag_core::ag_core-static)
	endif()

	get_target_property(AGAR_INCLUDE_DIRS ag_core::ag_core INTERFACE_INCLUDE_DIRECTORIES)
	list(APPEND AGAR_INCLUDE_DIRS ${AGAR_INCLUDE_DIRS})

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_core::ag_core ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_core::ag_core ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_CORE_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_CORE_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_core::ag_core has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_core::ag_core INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_CORE_LIBRARIES ${AGAR_CORE_LIBRARIES} ${ag_deplib})
	endif()

	get_filename_component(AGAR_LIBDIR ${ag_implib} PATH)
	get_filename_component(AGAR_PREFIX ${AGAR_LIBDIR} PATH)
endif()

#
# Agar-GUI
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_guiTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_guiTargets.cmake")
	set(HAVE_AGAR_GUI ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_guiStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_guiStaticTargets.cmake")
	set(HAVE_AGAR_GUI ON)
endif()
if(HAVE_AGAR_GUI)
	if(NOT TARGET ag_gui::ag_gui AND TARGET ag_gui::ag_gui-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_gui::ag_gui-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_gui::ag_gui ALIAS ag_gui::ag_gui-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_gui::ag_gui ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_gui::ag_gui ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_GUI_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_GUI_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_gui::ag_gui has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_gui::ag_gui INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_GUI_LIBRARIES ${AGAR_GUI_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-AU
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_auTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_auTargets.cmake")
	set(HAVE_AGAR_AU ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_auStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_auStaticTargets.cmake")
	set(HAVE_AGAR_AU ON)
endif()
if(HAVE_AGAR_AU)
	if(NOT TARGET ag_au::ag_au AND TARGET ag_au::ag_au-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_au::ag_au-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_au::ag_au ALIAS ag_au::ag_au-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_au::ag_au ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_au::ag_au ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_AU_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_AU_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_au::ag_au has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_au::ag_au INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_AU_LIBRARIES ${AGAR_AU_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-Map
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_mapTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_mapTargets.cmake")
	set(HAVE_AGAR_MAP ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_mapStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_mapStaticTargets.cmake")
	set(HAVE_AGAR_MAP ON)
endif()
if(HAVE_AGAR_MAP)
	if(NOT TARGET ag_map::ag_map AND TARGET ag_map::ag_map-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_map::ag_map-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_map::ag_map ALIAS ag_map::ag_map-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_map::ag_map ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_map::ag_map ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_MAP_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_MAP_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_map::ag_map has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_map::ag_map INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_MAP_LIBRARIES ${AGAR_MAP_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-Math
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_mathTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_mathTargets.cmake")
	set(HAVE_AGAR_MATH ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_mathStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_mathStaticTargets.cmake")
	set(HAVE_AGAR_MATH ON)
endif()
if(HAVE_AGAR_MATH)
	if(NOT TARGET ag_math::ag_math AND TARGET ag_math::ag_math-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_math::ag_math-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_math::ag_math ALIAS ag_math::ag_math-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_math::ag_math ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_math::ag_math ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_MATH_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_MATH_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_math::ag_math has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_math::ag_math INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_MATH_LIBRARIES ${AGAR_MATH_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-Net
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_netTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_netTargets.cmake")
	set(HAVE_AGAR_NET ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_netStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_netStaticTargets.cmake")
	set(HAVE_AGAR_NET ON)
endif()
if(HAVE_AGAR_NET)
	if(NOT TARGET ag_net::ag_net AND TARGET ag_net::ag_net-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_net::ag_net-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_net::ag_net ALIAS ag_net::ag_net-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_net::ag_net ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_net::ag_net ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_NET_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_NET_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_net::ag_net has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_net::ag_net INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_NET_LIBRARIES ${AGAR_NET_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-SG
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_sgTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_sgTargets.cmake")
	set(HAVE_AGAR_SG ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_sgStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_sgStaticTargets.cmake")
	set(HAVE_AGAR_SG ON)
endif()
if(HAVE_AGAR_SG)
	if(NOT TARGET ag_sg::ag_sg AND TARGET ag_sg::ag_sg-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_sg::ag_sg-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_sg::ag_sg ALIAS ag_sg::ag_sg-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_sg::ag_sg ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_sg::ag_sg ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_SG_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_SG_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_sg::ag_sg has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_sg::ag_sg INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_SG_LIBRARIES ${AGAR_SG_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-SK
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_skTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_skTargets.cmake")
	set(HAVE_AGAR_SK ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_skStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_skStaticTargets.cmake")
	set(HAVE_AGAR_SK ON)
endif()
if(HAVE_AGAR_SK)
	if(NOT TARGET ag_sk::ag_sk AND TARGET ag_sk::ag_sk-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_sk::ag_sk-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_sk::ag_sk ALIAS ag_sk::ag_sk-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_sk::ag_sk ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_sk::ag_sk ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_SK_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_SK_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_sk::ag_sk has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_sk::ag_sk INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_SK_LIBRARIES ${AGAR_SK_LIBRARIES} ${ag_deplib})
	endif()
endif()

#
# Agar-VG
#
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_vgTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_vgTargets.cmake")
	set(HAVE_AGAR_VG ON)
endif()
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/ag_vgStaticTargets.cmake")
	include("${CMAKE_CURRENT_LIST_DIR}/ag_vgStaticTargets.cmake")
	set(HAVE_AGAR_VG ON)
endif()
if(HAVE_AGAR_VG)
	if(NOT TARGET ag_vg::ag_vg AND TARGET ag_vg::ag_vg-static)
		if(CMAKE_VERSION VERSION_LESS "3.18")
			set_target_properties(ag_vg::ag_vg-static PROPERTIES IMPORTED_GLOBAL TRUE)
		endif()
		add_library(ag_vg::ag_vg ALIAS ag_vg::ag_vg-static)
	endif()

	foreach(prop ${propsRelease})
		get_target_property(ag_implib ag_vg::ag_vg ${prop})
		if(ag_implib)
			break()
		endif()
	endforeach()
	foreach(prop ${propsDebug})
		get_target_property(ag_implibdbg ag_vg::ag_vg ${prop})
		if(ag_implibdbg)
			break()
		endif()
	endforeach()
	if(ag_implib AND ag_implibdbg)
		set(AGAR_VG_LIBRARIES $<IF:$<CONFIG:Debug>,${ag_implibdbg},${ag_implib}>)
	else()
		if((NOT ag_implib) AND ag_implibdbg)
			set(ag_implib ${ag_implibdbg})
		endif()
		if(ag_implib)
			set(AGAR_VG_LIBRARIES ${ag_implib})
		else()
			message(FATAL_ERROR, "ag_vg::ag_vg has no lib to link against in IMPORTED_IMPLIB* or IMPORTED_LOCATION*")
		endif()
	endif()

	get_target_property(ag_deplib ag_vg::ag_vg INTERFACE_LINK_LIBRARIES)
	if(ag_deplib)
		set(AGAR_VG_LIBRARIES ${AGAR_VG_LIBRARIES} ${ag_deplib})
	endif()
endif()

unset(propsRelease)
unset(propsDebug)
unset(ag_implib)
unset(ag_implibdbg)
unset(ag_deplib)
