" Vim syntax file
" Language:     LibAgar - Agar-Core C API
" URL:
" https://github.com/JulNadeauCA/libagar/blob/master/syntax/agarcore.vim
" Maintainer:   Julien Nadeau Carriere <vedge@csoft.net>
" Last Change:  2023 April 8

source $VIMRUNTIME/syntax/c.vim

if !exists("c_no_agar_attributes") || exists("c_agar_attributes_typedefs")
  syn keyword cStorageClass _Nonnull _Nullable _Null_unspecified
  syn keyword cStorageClass _Nonnull_Mutex _Nonnull_Cond _Nonnull_Thread
  syn keyword cStorageClass _Nullable_Mutex _Nullable_Cond _Nullable_Thread
  syn keyword cStorageClass _Null_unspecified_Mutex _Null_unspecified_Cond
  syn keyword cStorageClass _Null_unspecified_Thread
  syn keyword cStorageClass _Aligned_Attribute _Alloc_Align_Attribute
  syn keyword cStorageClass _Alloc_Size_Attribute _Alloc_Size2_Attribute
  syn keyword cStorageClass _Const_Attribute DEPRECATED_ATTRIBUTE
  syn keyword cStorageClass FORMAT_ATTRIBUTE _Malloc_Like_Attribute
  syn keyword cStorageClass _Packed_Attribute _Pure_Attribute
  syn keyword cStorageClass _Pure_Attribute_If_Unthreaded _Section_Attribute
  syn keyword cStorageClass _Unused_Variable_Attribute _Used_Variable_Attribute
  syn keyword cStorageClass _Warn_Unused_Result _Weak_Attribute _Noreturn_Attribute
  syn keyword cStorageClass _Restrict
endif

if !exists("c_no_agsi") || exists("c_agsi_typedefs")
  " core/agsi.h (SGR attributes)
  syn keyword cConstant AGSI_RST AGSI_BOLD AGSI_FAINT AGSI_ITALIC AGSI_UNDERLINE
  syn keyword cConstant AGSI_REVERSE AGSI_CROSSEDOUT AGSI_SUP AGSI_SUB
  syn keyword cConstant AGSI_FONT1 AGSI_FONT2
  syn keyword cConstant AGSI_FONT3 AGSI_FONT4 AGSI_FONT5 AGSI_FONT6 AGSI_FONT7
  syn keyword cConstant AGSI_FONT8 AGSI_FONT9 AGSI_FONT10 AGSI_FONT11 AGSI_FONT12
  syn keyword cConstant AGSI_FONT13 AGSI_FONT14
  syn keyword cConstant AGSI_FRAMED AGSI_ENCIRCLED AGSI_OVERLINED AGSI_NOTFRAMED
  syn keyword cConstant AGSI_BLK AGSI_RED AGSI_GRN AGSI_YEL AGSI_BLU AGSI_MAG
  syn keyword cConstant AGSI_CYAN AGSI_WHT AGSI_BR_BLK AGSI_GRAY AGSI_BR_RED
  syn keyword cConstant AGSI_BR_GRN AGSI_BR_YEL AGSI_BR_BLU AGSI_BR_MAG
  syn keyword cConstant AGSI_BR_CYAN AGSI_BR_WHT AGSI_BLK_BG AGSI_RED_BG
  syn keyword cConstant AGSI_GRN_BG AGSI_YEL_BG AGSI_BLU_BG AGSI_MAG_BG
  syn keyword cConstant AGSI_CYAN_BG AGSI_WHT_BG AGSI_BR_BLK_BG AGSI_GRAY_BG
  syn keyword cConstant AGSI_BR_RED_BG AGSI_BR_GRN_BG AGSI_BR_YEL_BG AGSI_BR_BLU_BG 
  syn keyword cConstant AGSI_BR_MAG_BG AGSI_BR_CYAN_BG AGSI_BR_WHT_BG

  " core/agsi.h (core fonts)
  syn keyword cConstant AGSI_ALGUE AGSI_UNIALGUE AGSI_AGAR_MINIMAL 
  syn keyword cConstant AGSI_AGAR_IDEOGRAMS AGSI_MONOALGUE AGSI_BITSTREAM_CHARTER
  syn keyword cConstant AGSI_NOTO_SERIF AGSI_NOTO_SANS AGSI_LEAGUE_SPARTAN
  syn keyword cConstant AGSI_LEAGUE_GOTHIC AGSI_UNIFRAKTUR_MAGUNTIA
  syn keyword cConstant AGSI_MONOSPACE AGSI_UNI AGSI_PATH AGSI_CODE AGSI_COURIER 
  syn keyword cConstant AGSI_FRAKTUR AGSI_IDEOGRAM AGSI_CHARTER AGSI_NOTO
  syn keyword cConstant AGSI_CJK 
  syn keyword cConstant AGSI_APPCMD AGSI_WINCMD AGSI_APPCMD_NAME AGSI_WINCMD_NAME

  " core/agsi.h (unicode character ranges)
  syn keyword cConstant AGSI_BASIC_LATIN_BEGIN AGSI_BASIC_LATIN_END AGSI_LATIN1_SUPPL_BEGIN AGSI_LATIN1_SUPPL_END
  syn keyword cConstant AGSI_LATIN_EXT_A_BEGIN AGSI_LATIN_EXT_A_END AGSI_LATIN_EXT_B_BEGIN AGSI_LATIN_EXT_B_END
  syn keyword cConstant AGSI_IPA_EXTENSIONS_BEGIN AGSI_IPA_EXTENSIONS_END
  syn keyword cConstant AGSI_SP_MOD_LETTERS_BEGIN AGSI_SP_MOD_LETTERS_END
  syn keyword cConstant AGSI_COMB_DIACRIT_MARKS_BEGIN AGSI_COMB_DIACRIT_MARKS_END
  syn keyword cConstant AGSI_GREEK_AND_COPTIC_BEGIN AGSI_GREEK_AND_COPTIC_END
  syn keyword cConstant AGSI_CYRILLIC_BEGIN AGSI_CYRILLIC_END AGSI_CYRILLIC_SUPPL_BEGIN AGSI_CYRILLIC_SUPPL_END
  syn keyword cConstant AGSI_ARMENIAN_BEGIN AGSI_ARMENIAN_END AGSI_HEBREW_BEGIN AGSI_HEBREW_END
  syn keyword cConstant AGSI_ARABIC_BEGIN AGSI_ARABIC_END AGSI_SYRIAC_BEGIN AGSI_SYRIAC_END
  syn keyword cConstant AGSI_ARABIC_SUPPL_BEGIN AGSI_ARABIC_SUPPL_END AGSI_THAANA_END AGSI_THAANA_BEGIN
  syn keyword cConstant AGSI_NKO_BEGIN AGSI_NKO_END AGSI_SAMARITAN_BEGIN AGSI_SAMARITAN_END
  syn keyword cConstant AGSI_MANDAIC_BEGIN AGSI_MANDAIC_END AGSI_SYRIAC_SUPPL_BEGIN AGSI_SYRIAC_SUPPL_END
  syn keyword cConstant AGSI_ARABIC_EXT_B_BEGIN AGSI_ARABIC_EXT_B_END AGSI_ARABIC_EXT_A_BEGIN AGSI_ARABIC_EXT_A_END
  syn keyword cConstant AGSI_DEVANAGARI_BEGIN AGSI_DEVANAGARI_END AGSI_BENGALI_BEGIN AGSI_BENGALI_END
  syn keyword cConstant AGSI_GURMUKHI_BEGIN AGSI_GURMUKHI_END AGSI_GUJARATI_BEGIN AGSI_GUJARATI_END
  syn keyword cConstant AGSI_ORIYA_BEGIN AGSI_ORIYA_END AGSI_TAMIL_BEGIN AGSI_TAMIL_END
  syn keyword cConstant AGSI_TELUGU_BEGIN AGSI_TELUGU_END AGSI_KANNADA_BEGIN AGSI_KANNADA_END
  syn keyword cConstant AGSI_MALAYALAM_BEGIN AGSI_MALAYALAM_END AGSI_SINHALA_BEGIN AGSI_SINHALA_END
  syn keyword cConstant AGSI_THAI_BEGIN AGSI_THAI_END AGSI_LAO_BEGIN AGSI_LAO_END
  syn keyword cConstant AGSI_TIBETAN_BEGIN AGSI_TIBETAN_END AGSI_MYANMAR_BEGIN AGSI_MYANMAR_END
  syn keyword cConstant AGSI_GEORGIAN_BEGIN AGSI_GEORGIAN_END AGSI_HANGUL_JAMO_BEGIN AGSI_HANGUL_JAMO_END
  syn keyword cConstant AGSI_ETHIOPIC_BEGIN AGSI_ETHIOPIC_END AGSI_ETHIOPIC_SUPPL_BEGIN AGSI_ETHIOPIC_SUPPL_END
  syn keyword cConstant AGSI_CHEROKEE_BEGIN AGSI_CHEROKEE_END
  syn keyword cConstant AGSI_UNI_CA_ABORIG_SYLL_BEGIN AGSI_UNI_CA_ABORIG_SYLL_END
  syn keyword cConstant AGSI_OGHAM_BEGIN AGSI_OGHAM_END AGSI_RUNIC_BEGIN AGSI_RUNIC_END
  syn keyword cConstant AGSI_TAGALOG_BEGIN AGSI_TAGALOG_END AGSI_HANUNOO_BEGIN AGSI_HANUNOO_END
  syn keyword cConstant AGSI_BUHID_BEGIN AGSI_BUHID_END AGSI_TAGBANWA_BEGIN AGSI_TAGBANWA_END
  syn keyword cConstant AGSI_KHMER_BEGIN AGSI_KHMER_END AGSI_MONGOLIAN_BEGIN AGSI_MONGOLIAN_END
  syn keyword cConstant AGSI_UNI_CA_ABORIG_SYLL_EXT_BEGIN AGSI_UNI_CA_ABORIG_SYLL_EXT_END
  syn keyword cConstant AGSI_LIMBU_BEGIN AGSI_LIMBU_END AGSI_TAI_LE_BEGIN AGSI_TAI_LE_END
  syn keyword cConstant AGSI_NEW_TAI_LUE_BEGIN AGSI_NEW_TAI_LUE_END AGSI_KHMER_SYM_BEGIN AGSI_KHMER_SYM_END
  syn keyword cConstant AGSI_BUGINESE_BEGIN AGSI_BUGINESE_END AGSI_TAI_THAM_BEGIN AGSI_TAI_THAM_END
  syn keyword cConstant AGSI_COMB_DIACRIT_MARKS_EXT_BEGIN AGSI_COMB_DIACRIT_MARKS_EXT_END
  syn keyword cConstant AGSI_BALINESE_BEGIN AGSI_BALINESE_END AGSI_SUNDANESE_BEGIN AGSI_SUNDANESE_END
  syn keyword cConstant AGSI_BATAK_BEGIN AGSI_BATAK_END AGSI_LEPCHA_BEGIN AGSI_LEPCHA_END
  syn keyword cConstant AGSI_OL_CHIKI_BEGIN AGSI_OL_CHIKI_END
  syn keyword cConstant AGSI_CYRILLIC_EXT_C_BEGIN AGSI_CYRILLIC_EXT_C_END
  syn keyword cConstant AGSI_GEORGIAN_EXT_BEGIN AGSI_GEORGIAN_EXT_END
  syn keyword cConstant AGSI_SUNDANESE_SUPPL_BEGIN AGSI_SUNDANESE_SUPPL_END
  syn keyword cConstant AGSI_VEDIC_EXTENSIONS_BEGIN AGSI_VEDIC_EXTENSIONS_END
  syn keyword cConstant AGSI_PHONETIC_EXTENSIONS_BEGIN AGSI_PHONETIC_EXTENSIONS_END
  syn keyword cConstant AGSI_COMB_DIACRIT_MARKS_SUPPL_BEGIN AGSI_COMB_DIACRIT_MARKS_SUPPL_END
  syn keyword cConstant AGSI_LATIN_EXT_ADDITIONAL_BEGIN AGSI_LATIN_EXT_ADDITIONAL_END
  syn keyword cConstant AGSI_GREEK_EXT_BEGIN AGSI_GREEK_EXT_END
  syn keyword cConstant AGSI_GENERAL_PUNCTUATION_BEGIN AGSI_GENERAL_PUNCTUATION_END
  syn keyword cConstant AGSI_SUPERSCRIPTS_AND_SUBSCRIPTS_BEGIN AGSI_SUPERSCRIPTS_AND_SUBSCRIPTS_END
  syn keyword cConstant AGSI_CURRENCY_SYM_BEGIN AGSI_CURRENCY_SYM_END
  syn keyword cConstant AGSI_COMB_DIACRIT_MARKS_FOR_SYM_BEGIN AGSI_COMB_DIACRIT_MARKS_FOR_SYM_END
  syn keyword cConstant AGSI_LETTERLIKE_SYM_BEGIN AGSI_LETTERLIKE_SYM_END
  syn keyword cConstant AGSI_NUMBER_FORMS_BEGIN AGSI_NUMBER_FORMS_END AGSI_ARROWS_BEGIN AGSI_ARROWS_END
  syn keyword cConstant AGSI_MATH_OPERATORS_BEGIN AGSI_MATH_OPERATORS_END
  syn keyword cConstant AGSI_MISC_TECH_BEGIN AGSI_MISC_TECH_END
  syn keyword cConstant AGSI_CONTROL_PICTURES_BEGIN AGSI_CONTROL_PICTURES_END AGSI_OCR_BEGIN AGSI_OCR_END
  syn keyword cConstant AGSI_ENCLOSED_ALPHANUMERICS_BEGIN AGSI_ENCLOSED_ALPHANUMERICS_END
  syn keyword cConstant AGSI_BOX_DRAWING_BEGIN AGSI_BOX_DRAWING_END AGSI_BLOCK_ELEMENTS_BEGIN AGSI_BLOCK_ELEMENTS_END
  syn keyword cConstant AGSI_GEOMETRIC_SHAPES_BEGIN AGSI_GEOMETRIC_SHAPES_END
  syn keyword cConstant AGSI_MISC_SYM_BEGIN AGSI_MISC_SYM_END AGSI_DINGBATS_BEGIN AGSI_DINGBATS_END
  syn keyword cConstant AGSI_MISC_MATH_SYM_A_BEGIN AGSI_MISC_MATH_SYM_A_END
  syn keyword cConstant AGSI_SUPPL_ARROWS_A_BEGIN AGSI_SUPPL_ARROWS_A_END
  syn keyword cConstant AGSI_BRAILLE_PATTERNS_BEGIN AGSI_BRAILLE_PATTERNS_END
  syn keyword cConstant AGSI_SUPPL_ARROWS_B_BEGIN AGSI_SUPPL_ARROWS_B_END
  syn keyword cConstant AGSI_MISC_MATH_SYM_B_BEGIN AGSI_MISC_MATH_SYM_B_END
  syn keyword cConstant AGSI_SUPPL_MATH_OPERATORS_BEGIN AGSI_SUPPL_MATH_OPERATORS_END
  syn keyword cConstant AGSI_MISC_SYM_AND_ARROWS_BEGIN AGSI_MISC_SYM_AND_ARROWS_END
  syn keyword cConstant AGSI_GLAGOLITIC_BEGIN AGSI_GLAGOLITIC_END
  syn keyword cConstant AGSI_LATIN_EXT_C_BEGIN AGSI_LATIN_EXT_C_END AGSI_COPTIC_BEGIN AGSI_COPTIC_END
  syn keyword cConstant AGSI_GEORGIAN_SUPPL_BEGIN AGSI_GEORGIAN_SUPPL_END
  syn keyword cConstant AGSI_TIFINAGH_BEGIN AGSI_TIFINAGH_END AGSI_ETHIOPIC_EXT_BEGIN AGSI_ETHIOPIC_EXT_END
  syn keyword cConstant AGSI_CYRILLIC_EXT_A_BEGIN AGSI_CYRILLIC_EXT_A_END
  syn keyword cConstant AGSI_SUPPL_PUNCTUATION_BEGIN AGSI_SUPPL_PUNCTUATION_END
  syn keyword cConstant AGSI_CJK_RADICALS_SUPPL_BEGIN AGSI_CJK_RADICALS_SUPPL_END
  syn keyword cConstant AGSI_KANGXI_RADICALS_BEGIN AGSI_KANGXI_RADICALS_END
  syn keyword cConstant AGSI_IDEO_DESCR_CHARS_BEGIN AGSI_IDEO_DESCR_CHARS_END
  syn keyword cConstant AGSI_CJK_SYM_AND_PUNCT_BEGIN AGSI_CJK_SYM_AND_PUNCT_END
  syn keyword cConstant AGSI_HIRAGANA_BEGIN AGSI_HIRAGANA_END AGSI_KATAKANA_BEGIN AGSI_KATAKANA_END
  syn keyword cConstant AGSI_BOPOMOFO_BEGIN AGSI_BOPOMOFO_END AGSI_HANGUL_COMPAT_JAMO_BEGIN AGSI_HANGUL_COMPAT_JAMO_END
  syn keyword cConstant AGSI_KANBUN_BEGIN AGSI_KANBUN_END AGSI_BOPOMOFO_EXT_BEGIN AGSI_BOPOMOFO_EXT_END
  syn keyword cConstant AGSI_CJK_STROKES_BEGIN AGSI_CJK_STROKES_END
  syn keyword cConstant AGSI_KATAKANA_PHONETIC_EXTS_BEGIN AGSI_KATAKANA_PHONETIC_EXTS_END
  syn keyword cConstant AGSI_ENCL_CJK_LETTERS_MONTHS_BEGIN AGSI_ENCL_CJK_LETTERS_MONTHS_END
  syn keyword cConstant AGSI_CJK_COMPAT_BEGIN AGSI_CJK_COMPAT_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_A_BEGIN AGSI_CJK_UNI_IDEO_EXT_A_END
  syn keyword cConstant AGSI_YIJING_HEXAGRAM_SYM_BEGIN AGSI_YIJING_HEXAGRAM_SYM_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_BEGIN AGSI_CJK_UNI_IDEO_END
  syn keyword cConstant AGSI_YI_SYLLABLES_BEGIN AGSI_YI_SYLLABLES_END
  syn keyword cConstant AGSI_YI_RADICALS_BEGIN AGSI_YI_RADICALS_END
  syn keyword cConstant AGSI_LISU_BEGIN AGSI_LISU_END
  syn keyword cConstant AGSI_VAI_BEGIN AGSI_VAI_END
  syn keyword cConstant AGSI_CYRILLIC_EXT_B_BEGIN AGSI_CYRILLIC_EXT_B_END AGSI_BAMUM_BEGIN AGSI_BAMUM_END
  syn keyword cConstant AGSI_MOD_TONE_LETTERS_BEGIN AGSI_MOD_TONE_LETTERS_END
  syn keyword cConstant AGSI_LATIN_EXT_D_BEGIN AGSI_LATIN_EXT_D_END AGSI_SYLOTI_NAGRI_BEGIN AGSI_SYLOTI_NAGRI_END
  syn keyword cConstant AGSI_COMMON_INDIC_NUMBER_FORMS_BEGIN AGSI_COMMON_INDIC_NUMBER_FORMS_END
  syn keyword cConstant AGSI_PHAGS_PA_BEGIN AGSI_PHAGS_PA_END AGSI_SAURASHTRA_BEGIN AGSI_SAURASHTRA_END
  syn keyword cConstant AGSI_DEVANAGARI_EXT_BEGIN AGSI_DEVANAGARI_EXT_END AGSI_KAYAH_LI_BEGIN AGSI_KAYAH_LI_END
  syn keyword cConstant AGSI_REJANG_BEGIN AGSI_REJANG_END AGSI_HANGUL_JAMO_EXT_A_BEGIN AGSI_HANGUL_JAMO_EXT_A_END
  syn keyword cConstant AGSI_JAVANESE_BEGIN AGSI_JAVANESE_END AGSI_MYANMAR_EXT_B_BEGIN AGSI_MYANMAR_EXT_B_END
  syn keyword cConstant AGSI_CHAM_BEGIN AGSI_CHAM_END AGSI_MYANMAR_EXT_A_BEGIN AGSI_MYANMAR_EXT_A_END
  syn keyword cConstant AGSI_TAI_VIET_BEGIN AGSI_TAI_VIET_END
  syn keyword cConstant AGSI_MEETEI_MAYEK_EXTENSIONS_BEGIN AGSI_MEETEI_MAYEK_EXTENSIONS_END
  syn keyword cConstant AGSI_ETHIOPIC_EXT_A_BEGIN AGSI_ETHIOPIC_EXT_A_END
  syn keyword cConstant AGSI_LATIN_EXT_E_BEGIN AGSI_LATIN_EXT_E_END
  syn keyword cConstant AGSI_CHEROKEE_SUPPL_BEGIN AGSI_CHEROKEE_SUPPL_END
  syn keyword cConstant AGSI_MEETEI_MAYEK_BEGIN AGSI_MEETEI_MAYEK_END
  syn keyword cConstant AGSI_HANGUL_SYLLABLES_BEGIN AGSI_HANGUL_SYLLABLES_END
  syn keyword cConstant AGSI_HANGUL_JAMO_EXT_B_BEGIN AGSI_HANGUL_JAMO_EXT_B_END
  syn keyword cConstant AGSI_HIGH_SURROGATE_AREA_BEGIN AGSI_HIGH_SURROGATE_AREA_END
  syn keyword cConstant AGSI_LOW_SURROGATE_AREA_BEGIN AGSI_LOW_SURROGATE_AREA_END
  syn keyword cConstant AGSI_PRIVATE_USE_AREA_BEGIN AGSI_PRIVATE_USE_AREA_END
  syn keyword cConstant AGSI_CJK_COMPAT_IDEO_BEGIN AGSI_CJK_COMPAT_IDEO_END
  syn keyword cConstant AGSI_ALPHA_PRES_FORMS_BEGIN AGSI_ALPHA_PRES_FORMS_END
  syn keyword cConstant AGSI_ARABIC_PRES_FORMS_A_BEGIN AGSI_ARABIC_PRES_FORMS_A_END
  syn keyword cConstant AGSI_VARIATION_SELECTORS_BEGIN AGSI_VARIATION_SELECTORS_END
  syn keyword cConstant AGSI_VERTICAL_FORMS_BEGIN AGSI_VERTICAL_FORMS_END
  syn keyword cConstant AGSI_COMBINING_HALF_MARKS_BEGIN AGSI_COMBINING_HALF_MARKS_END
  syn keyword cConstant AGSI_CJK_COMPAT_FORMS_BEGIN AGSI_CJK_COMPAT_FORMS_END
  syn keyword cConstant AGSI_SMALL_FORM_VARIANTS_BEGIN AGSI_SMALL_FORM_VARIANTS_END
  syn keyword cConstant AGSI_ARABIC_PRES_FORMS_B_BEGIN AGSI_ARABIC_PRES_FORMS_B_END
  syn keyword cConstant AGSI_HALFWIDTH_FULLWIDTH_FORMS_BEGIN AGSI_HALFWIDTH_FULLWIDTH_FORMS_END
  syn keyword cConstant AGSI_SPECIALS_BEGIN AGSI_SPECIALS_END
  syn keyword cConstant AGSI_LINEAR_B_SYLLABARY_BEGIN AGSI_LINEAR_B_SYLLABARY_END
  syn keyword cConstant AGSI_LINEAR_B_IDEOGRAMS_BEGIN AGSI_LINEAR_B_IDEOGRAMS_END
  syn keyword cConstant AGSI_AEGEAN_NUMBERS_BEGIN AGSI_AEGEAN_NUMBERS_END
  syn keyword cConstant AGSI_ANCIENT_GREEK_NUMBERS_BEGIN AGSI_ANCIENT_GREEK_NUMBERS_END
  syn keyword cConstant AGSI_ANCIENT_SYM_BEGIN AGSI_ANCIENT_SYM_END
  syn keyword cConstant AGSI_PHAISTOS_DISC_BEGIN AGSI_PHAISTOS_DISC_END
  syn keyword cConstant AGSI_LYCIAN_BEGIN AGSI_LYCIAN_END AGSI_CARIAN_BEGIN AGSI_CARIAN_END
  syn keyword cConstant AGSI_COPTIC_EPACT_NUMBERS_BEGIN AGSI_COPTIC_EPACT_NUMBERS_END
  syn keyword cConstant AGSI_OLD_ITALIC_BEGIN AGSI_OLD_ITALIC_END AGSI_GOTHIC_BEGIN AGSI_GOTHIC_END
  syn keyword cConstant AGSI_OLD_PERMIC_BEGIN AGSI_OLD_PERMIC_END AGSI_UGARITIC_BEGIN AGSI_UGARITIC_END
  syn keyword cConstant AGSI_OLD_PERSIAN_BEGIN AGSI_OLD_PERSIAN_END AGSI_DESERET_BEGIN AGSI_DESERET_END
  syn keyword cConstant AGSI_SHAVIAN_BEGIN AGSI_SHAVIAN_END AGSI_OSMANYA_BEGIN AGSI_OSMANYA_END
  syn keyword cConstant AGSI_OSAGE_BEGIN AGSI_OSAGE_END AGSI_ELBASAN_BEGIN AGSI_ELBASAN_END
  syn keyword cConstant AGSI_CAUCASIAN_ALBANIAN_BEGIN AGSI_CAUCASIAN_ALBANIAN_END
  syn keyword cConstant AGSI_VITHKUQI_BEGIN AGSI_VITHKUQI_END
  syn keyword cConstant AGSI_LINEAR_A_BEGIN AGSI_LINEAR_A_END
  syn keyword cConstant AGSI_LATIN_EXT_F_BEGIN AGSI_LATIN_EXT_F_END AGSI_CYPRIOT_SYLLABARY_BEGIN AGSI_CYPRIOT_SYLLABARY_END
  syn keyword cConstant AGSI_IMPERIAL_ARAMAIC_BEGIN AGSI_IMPERIAL_ARAMAIC_END AGSI_PALMYRENE_BEGIN AGSI_PALMYRENE_END
  syn keyword cConstant AGSI_NABATAEAN_BEGIN AGSI_NABATAEAN_END AGSI_HATRAN_BEGIN AGSI_HATRAN_END
  syn keyword cConstant AGSI_PHOENICIAN_BEGIN AGSI_PHOENICIAN_END AGSI_LYDIAN_BEGIN AGSI_LYDIAN_END
  syn keyword cConstant AGSI_MEROITIC_HIEROGLYPHS_BEGIN AGSI_MEROITIC_HIEROGLYPHS_END
  syn keyword cConstant AGSI_MEROITIC_CURSIVE_BEGIN AGSI_MEROITIC_CURSIVE_END
  syn keyword cConstant AGSI_KHAROSHTHI_BEGIN AGSI_KHAROSHTHI_END
  syn keyword cConstant AGSI_OLD_SOUTH_ARABIAN_BEGIN AGSI_OLD_SOUTH_ARABIAN_END
  syn keyword cConstant AGSI_OLD_NORTH_ARABIAN_BEGIN AGSI_OLD_NORTH_ARABIAN_END
  syn keyword cConstant AGSI_MANICHAEAN_BEGIN AGSI_MANICHAEAN_END AGSI_AVESTAN_BEGIN AGSI_AVESTAN_END
  syn keyword cConstant AGSI_INSCRIPTIONAL_PARTHIAN_BEGIN AGSI_INSCRIPTIONAL_PARTHIAN_END
  syn keyword cConstant AGSI_INSCRIPTIONAL_PAHLAVI_BEGIN AGSI_INSCRIPTIONAL_PAHLAVI_END
  syn keyword cConstant AGSI_PSALTER_PAHLAVI_BEGIN AGSI_PSALTER_PAHLAVI_END
  syn keyword cConstant AGSI_OLD_TURKIC_BEGIN AGSI_OLD_TURKIC_END AGSI_OLD_HUNGARIAN_BEGIN AGSI_OLD_HUNGARIAN_END
  syn keyword cConstant AGSI_HANIFI_ROHINGYA_BEGIN AGSI_HANIFI_ROHINGYA_END
  syn keyword cConstant AGSI_RUMI_NUMERAL_SYM_BEGIN AGSI_RUMI_NUMERAL_SYM_END
  syn keyword cConstant AGSI_YEZIDI_BEGIN AGSI_YEZIDI_END AGSI_OLD_SOGDIAN_BEGIN AGSI_OLD_SOGDIAN_END
  syn keyword cConstant AGSI_SOGDIAN_BEGIN AGSI_SOGDIAN_END AGSI_OLD_UYGHUR_BEGIN AGSI_OLD_UYGHUR_END
  syn keyword cConstant AGSI_CHORASMIAN_BEGIN AGSI_CHORASMIAN_END AGSI_ELMAIC_BEGIN AGSI_ELMAIC_END
  syn keyword cConstant AGSI_BRAHMI_BEGIN AGSI_BRAHMI_END AGSI_KAITHI_BEGIN AGSI_KAITHI_END
  syn keyword cConstant AGSI_SORA_SOMPENG_BEGIN AGSI_SORA_SOMPENG_END AGSI_CHAKMA_BEGIN AGSI_CHAKMA_END
  syn keyword cConstant AGSI_MAHAJANI_BEGIN AGSI_MAHAJANI_END AGSI_SHARADA_BEGIN AGSI_SHARADA_END
  syn keyword cConstant AGSI_SINHALA_ARCHAIC_NUMBERS_BEGIN AGSI_SINHALA_ARCHAIC_NUMBERS_END
  syn keyword cConstant AGSI_KHOJKI_BEGIN AGSI_KHOJKI_END AGSI_MULTANI_BEGIN AGSI_MULTANI_END
  syn keyword cConstant AGSI_KHUDAWADI_BEGIN AGSI_KHUDAWADI_END AGSI_GRANTHA_BEGIN AGSI_GRANTHA_END
  syn keyword cConstant AGSI_NEWA_BEGIN AGSI_NEWA_END AGSI_TIRHUTA_BEGIN AGSI_TIRHUTA_END
  syn keyword cConstant AGSI_SIDDHAM_BEGIN AGSI_SIDDHAM_END AGSI_MODI_BEGIN AGSI_MODI_END
  syn keyword cConstant AGSI_MONGOLIAN_SUPPL_BEGIN AGSI_MONGOLIAN_SUPPL_END
  syn keyword cConstant AGSI_TAKRI_BEGIN AGSI_TAKRI_END AGSI_AHOM_BEGIN AGSI_AHOM_END
  syn keyword cConstant AGSI_DOGRA_BEGIN AGSI_DOGRA_END AGSI_WARANG_CITI_BEGIN AGSI_WARANG_CITI_END
  syn keyword cConstant AGSI_DIVES_AKURU_BEGIN AGSI_DIVES_AKURU_END AGSI_NANDINAGARI_BEGIN AGSI_NANDINAGARI_END
  syn keyword cConstant AGSI_ZANABAZAR_SQUARE_BEGIN AGSI_ZANABAZAR_SQUARE_END AGSI_SOYOMBO_BEGIN AGSI_SOYOMBO_END
  syn keyword cConstant AGSI_UNI_CA_ABORIG_SYLL_EXT_A_BEGIN AGSI_UNI_CA_ABORIG_SYLL_EXT_A_END
  syn keyword cConstant AGSI_PAU_CIN_HAU_BEGIN AGSI_PAU_CIN_HAU_END AGSI_BHAIKSUKI_BEGIN AGSI_BHAIKSUKI_END
  syn keyword cConstant AGSI_MARCHEN_BEGIN AGSI_MARCHEN_END AGSI_MASARAM_GONDI_BEGIN AGSI_MASARAM_GONDI_END
  syn keyword cConstant AGSI_GUNJALA_GONDI_BEGIN AGSI_GUNJALA_GONDI_END AGSI_MAKASAR_BEGIN AGSI_MAKASAR_END
  syn keyword cConstant AGSI_LISU_SUPPL_BEGIN AGSI_LISU_SUPPL_END AGSI_TAMIL_SUPPL_BEGIN AGSI_TAMIL_SUPPL_END
  syn keyword cConstant AGSI_CUNEIFORM_BEGIN AGSI_CUNEIFORM_END
  syn keyword cConstant AGSI_CUNEIFORM_NUMBERS_AND_PUNCT_BEGIN AGSI_CUNEIFORM_NUMBERS_AND_PUNCT_END
  syn keyword cConstant AGSI_EARLY_DYNASTIC_CUNEIFORM_BEGIN AGSI_EARLY_DYNASTIC_CUNEIFORM_END
  syn keyword cConstant AGSI_CYPRO_MINOAN_BEGIN AGSI_CYPRO_MINOAN_END
  syn keyword cConstant AGSI_EGYPTIAN_HIEROGLYPHS_BEGIN AGSI_EGYPTIAN_HIEROGLYPHS_END
  syn keyword cConstant AGSI_EGYPTIAN_HIEROGLYPHS_FMT_BEGIN AGSI_EGYPTIAN_HIEROGLYPHS_FMT_END
  syn keyword cConstant AGSI_ANATOLIAN_HIEROGLYPHS_BEGIN AGSI_ANATOLIAN_HIEROGLYPHS_END
  syn keyword cConstant AGSI_BAMUM_SUPPL_BEGIN AGSI_BAMUM_SUPPL_END
  syn keyword cConstant AGSI_MRO_BEGIN AGSI_MRO_END AGSI_TANGSA_BEGIN AGSI_TANGSA_END
  syn keyword cConstant AGSI_BASSA_VAH_BEGIN AGSI_BASSA_VAH_END AGSI_PAHAWH_HMONG_BEGIN AGSI_PAHAWH_HMONG_END
  syn keyword cConstant AGSI_MEDEFAIDRIN_BEGIN AGSI_MEDEFAIDRIN_END AGSI_MIAO_BEGIN AGSI_MIAO_END
  syn keyword cConstant AGSI_IDEO_SYM_AND_PUNCT_BEGIN AGSI_IDEO_SYM_AND_PUNCT_END
  syn keyword cConstant AGSI_TANGUT_BEGIN AGSI_TANGUT_END AGSI_TANGUT_COMPONENTS_BEGIN AGSI_TANGUT_COMPONENTS_END
  syn keyword cConstant AGSI_KHITAN_SMALL_SCRIPT_BEGIN AGSI_KHITAN_SMALL_SCRIPT_END
  syn keyword cConstant AGSI_TANGUT_SUPPL_BEGIN AGSI_TANGUT_SUPPL_END
  syn keyword cConstant AGSI_KANA_EXT_B_BEGIN AGSI_KANA_EXT_B_END AGSI_KANA_SUPPL_BEGIN AGSI_KANA_SUPPL_END
  syn keyword cConstant AGSI_KANA_EXT_A_BEGIN AGSI_KANA_EXT_A_END AGSI_SMALL_KANA_EXT_BEGIN AGSI_SMALL_KANA_EXT_END
  syn keyword cConstant AGSI_NUSHU_BEGIN AGSI_NUSHU_END
  syn keyword cConstant AGSI_DUPLOYAN_BEGIN AGSI_DUPLOYAN_END
  syn keyword cConstant AGSI_SHORTHAND_FORMAT_CONTROLS_BEGIN AGSI_SHORTHAND_FORMAT_CONTROLS_END
  syn keyword cConstant AGSI_ZNAMENNY_MUSICAL_NOT_BEGIN AGSI_ZNAMENNY_MUSICAL_NOT_END
  syn keyword cConstant AGSI_BYZANTINE_MUSICAL_SYM_BEGIN AGSI_BYZANTINE_MUSICAL_SYM_END
  syn keyword cConstant AGSI_MUSICAL_SYM_BEGIN AGSI_MUSICAL_SYM_END
  syn keyword cConstant AGSI_ANCIENT_GREEK_MUSICAL_NOT_BEGIN AGSI_ANCIENT_GREEK_MUSICAL_NOT_END
  syn keyword cConstant AGSI_MAYAN_NUMERALS_BEGIN AGSI_MAYAN_NUMERALS_END
  syn keyword cConstant AGSI_TAI_XUAN_JING_SYM_BEGIN AGSI_TAI_XUAN_JING_SYM_END
  syn keyword cConstant AGSI_COUNTING_ROD_NUMERALS_BEGIN AGSI_COUNTING_ROD_NUMERALS_END
  syn keyword cConstant AGSI_MATH_ALPHANUMERIC_SYM_BEGIN AGSI_MATH_ALPHANUMERIC_SYM_END
  syn keyword cConstant AGSI_SUTTON_SIGNWRITING_BEGIN AGSI_SUTTON_SIGNWRITING_END
  syn keyword cConstant AGSI_LATIN_EXT_G_BEGIN AGSI_LATIN_EXT_G_END
  syn keyword cConstant AGSI_GLAGOLITIC_SUPPL_BEGIN AGSI_GLAGOLITIC_SUPPL_END
  syn keyword cConstant AGSI_NYIAKENG_PUACHUE_HMONG_BEGIN AGSI_NYIAKENG_PUACHUE_HMONG_END
  syn keyword cConstant AGSI_TOTO_BEGIN AGSI_TOTO_END AGSI_WANCHO_BEGIN AGSI_WANCHO_END
  syn keyword cConstant AGSI_ETHIOPIC_EXT_B_BEGIN AGSI_ETHIOPIC_EXT_B_END
  syn keyword cConstant AGSI_MENDE_KIKAKUI_BEGIN AGSI_MENDE_KIKAKUI_END AGSI_ADLAM_BEGIN AGSI_ADLAM_END
  syn keyword cConstant AGSI_INDIC_SIYAQ_NUMBERS_BEGIN AGSI_INDIC_SIYAQ_NUMBERS_END
  syn keyword cConstant AGSI_OTTOMAN_SIYAQ_NUMBERS_BEGIN AGSI_OTTOMAN_SIYAQ_NUMBERS_END
  syn keyword cConstant AGSI_ARABIC_MATH_ALPHABETIC_SYM_BEGIN AGSI_ARABIC_MATH_ALPHABETIC_SYM_END
  syn keyword cConstant AGSI_MAHJONG_TILES_BEGIN AGSI_MAHJONG_TILES_END
  syn keyword cConstant AGSI_DOMINO_TILES_BEGIN AGSI_DOMINO_TILES_END
  syn keyword cConstant AGSI_PLAYING_CARDS_BEGIN AGSI_PLAYING_CARDS_END
  syn keyword cConstant AGSI_ENCL_ALPHANUMERIC_SUPPL_BEGIN AGSI_ENCL_ALPHANUMERIC_SUPPL_END
  syn keyword cConstant AGSI_ENCL_IDEOGRAPHIC_SUPPL_BEGIN AGSI_ENCL_IDEOGRAPHIC_SUPPL_END
  syn keyword cConstant AGSI_MISC_SYM_AND_PIC_BEGIN AGSI_MISC_SYM_AND_PIC_END
  syn keyword cConstant AGSI_EMOTICONS_BEGIN AGSI_EMOTICONS_END
  syn keyword cConstant AGSI_ORNAMENTAL_DINGBATS_BEGIN AGSI_ORNAMENTAL_DINGBATS_END
  syn keyword cConstant AGSI_TRANSPORT_AND_MAP_SYM_BEGIN AGSI_TRANSPORT_AND_MAP_SYM_END
  syn keyword cConstant AGSI_ALCHEMICAL_SYM_BEGIN AGSI_ALCHEMICAL_SYM_END
  syn keyword cConstant AGSI_GEOMETRIC_SHAPES_EXT_BEGIN AGSI_GEOMETRIC_SHAPES_EXT_END
  syn keyword cConstant AGSI_SUPPL_ARROWS_C_BEGIN AGSI_SUPPL_ARROWS_C_END
  syn keyword cConstant AGSI_SUPPL_SYM_AND_PIC_BEGIN AGSI_SUPPL_SYM_AND_PIC_END
  syn keyword cConstant AGSI_CHESS_SYM_BEGIN AGSI_CHESS_SYM_END
  syn keyword cConstant AGSI_SYM_AND_PIC_EXT_A_BEGIN AGSI_SYM_AND_PIC_EXT_A_END
  syn keyword cConstant AGSI_SYM_FOR_LEGACY_COMPUTING_BEGIN AGSI_SYM_FOR_LEGACY_COMPUTING_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_B_BEGIN AGSI_CJK_UNI_IDEO_EXT_B_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_C_BEGIN AGSI_CJK_UNI_IDEO_EXT_C_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_D_BEGIN AGSI_CJK_UNI_IDEO_EXT_D_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_E_BEGIN AGSI_CJK_UNI_IDEO_EXT_E_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_F_BEGIN AGSI_CJK_UNI_IDEO_EXT_F_END
  syn keyword cConstant AGSI_CJK_COMPAT_IDEO_SUPPL_BEGIN AGSI_CJK_COMPAT_IDEO_SUPPL_END
  syn keyword cConstant AGSI_CJK_UNI_IDEO_EXT_G_BEGIN AGSI_CJK_UNI_IDEO_EXT_G_END
  syn keyword cConstant AGSI_TAGS_BEGIN AGSI_TAGS_END
  syn keyword cConstant AGSI_VARIATION_SELECTORS_SUPPL_BEGIN AGSI_VARIATION_SELECTORS_SUPPL_END
  syn keyword cConstant AGSI_SUPPL_PRIVATE_USE_AREA_A_BEGIN AGSI_SUPPL_PRIVATE_USE_AREA_A_END
  syn keyword cConstant AGSI_SUPPL_PRIVATE_USE_AREA_B_BEGIN AGSI_SUPPL_PRIVATE_USE_AREA_B_END

  " core/agsi.h (general punctuation)
  syn keyword cConstant AGSI_GENERAL_PUNCTUATION_BEGIN
  syn keyword cConstant AGSI_THIN_SPACE AGSI_HYPHEN AGSI_NON_BREAKING_HYPHEN
  syn keyword cConstant AGSI_FIGURE_DASH AGSI_EN_DASH AGSI_EM_DASH
  syn keyword cConstant AGSI_HBAR AGSI_DOUBLE_VERTICAL_LINE
  syn keyword cConstant AGSI_DOUBLE_LOW_LINE AGSI_QUOTE_LEFT AGSI_QUOTE_RIGHT
  syn keyword cConstant AGSI_QUOTE_BASE AGSI_QUOTE_REVERSED
  syn keyword cConstant AGSI_DBLQUOTE_LEFT AGSI_DBLQUOTE_RIGHT AGSI_DBLQUOTE_REVERSED
  syn keyword cConstant AGSI_DAGGER AGSI_DBLDAGGER AGSI_TRIANGULAR_BULLET
  syn keyword cConstant AGSI_ONE_DOT_LEADER AGSI_TWO_DOT_LEADER AGSI_ELLIPSIS
  syn keyword cConstant AGSI_HYPHENATION_POINT AGSI_PER_THOUSAND AGSI_PER_TEN_THOUSAND
  syn keyword cConstant AGSI_PRIME AGSI_DOUBLE_PRIME AGSI_MINUTE AGSI_SECOND
  syn keyword cConstant AGSI_TRIPLE_PRIME AGSI_REVERSED_PRIME
  syn keyword cConstant AGSI_REVERSED_DOUBLE_PRIME AGSI_REVERSED_TRIPLE_PRIME
  syn keyword cConstant AGSI_CARET AGSI_GUILSINGL_LEFT AGSI_GUILSINGL_RIGHT
  syn keyword cConstant AGSI_REFERENCE_MARK AGSI_EXCLAM_DBL AGSI_INTERROBANG
  syn keyword cConstant AGSI_OVERLINE AGSI_UNDERTIE AGSI_CHARACTER_TIE
  syn keyword cConstant AGSI_CARET_INSERTION_POINT AGSI_ASTERISM AGSI_HYPHEN_BULLET
  syn keyword cConstant AGSI_FRACTION_SLASH AGSI_L_SQ_BRACKET_W_QUILL AGSI_R_SQ_BRACKET_W_QUILL
  syn keyword cConstant AGSI_DOUBLE_QUESTION AGSI_QUESTION_EXCLAMATION AGSI_EXCLAMATION_QUESTION
  syn keyword cConstant AGSI_TIRONIAN_SIGN_ET AGSI_REVERSED_PILCROW_SIGN
  syn keyword cConstant AGSI_BLACK_LEFTWARDS_BULLET AGSI_BLACK_RIGHTWARDS_BULLET
  syn keyword cConstant AGSI_LOW_ASTERISK AGSI_REVERSED_SEMICOLON AGSI_CLOSE_UP
  syn keyword cConstant AGSI_TWO_ASTERISKS_VALIGNED AGSI_COMMERCIAL_MINUS_SIGN
  syn keyword cConstant AGSI_SWUNG_DASH AGSI_INVERTED_UNDERTIE AGSI_FLOWER_PUNCTUATION
  syn keyword cConstant AGSI_THREE_DOT_PUNCTUATION AGSI_QUADRUPLE_PRIME
  syn keyword cConstant AGSI_FOUR_DOT_PUNCTUATION AGSI_FIVE_DOT_PUNCTUATION
  syn keyword cConstant AGSI_TWO_DOT_PUNCTUATION AGSI_FOUR_DOTS AGSI_DOTTED_CROSS
  syn keyword cConstant AGSI_TRICOLON AGSI_VERTICAL_FOUR_DOTS AGSI_MEDIUM_MATH_SPACE
  syn keyword cConstant AGSI_WORD_JOINER AGSI_FUNCTION_APPLICATION AGSI_INVISIBLE_TIMES
  syn keyword cConstant AGSI_INVISIBLE_SEPARATOR AGSI_INVISIBLE_PLUS
  syn keyword cConstant AGSI_INH_SYMMETRIC_SWAPPING AGSI_ACT_SYMMETRIC_SWAPPING
  syn keyword cConstant AGSI_INH_ARABIC_FORM_SHAPING AGSI_ACT_ARABIC_FORM_SHAPING
  syn keyword cConstant AGSI_NATIONAL_DIGIT_SHAPES
  syn keyword cConstant AGSI_GENERAL_PUNCTUATION_END

  " core/agsi.h (superscripts and subscripts)
  syn keyword cConstant AGSI_SUPERSCRIPTS_AND_SUBSCRIPTS_BEGIN
  syn keyword cConstant AGSI_SUPERSCRIPTS_BEGIN
  syn keyword cConstant AGSI_SUPERSCRIPT_0 AGSI_SUPERSCRIPT_SMALL_I
  syn keyword cConstant AGSI_SUPERSCRIPT_4 AGSI_SUPERSCRIPT_5 AGSI_SUPERSCRIPT_6
  syn keyword cConstant AGSI_SUPERSCRIPT_7 AGSI_SUPERSCRIPT_8 AGSI_SUPERSCRIPT_9
  syn keyword cConstant AGSI_SUPERSCRIPT_PLUS AGSI_SUPERSCRIPT_MINUS
  syn keyword cConstant AGSI_SUPERSCRIPT_EQUALS AGSI_SUPERSCRIPT_L_PAREN
  syn keyword cConstant AGSI_SUPERSCRIPT_R_PAREN AGSI_SUPERSCRIPT_SMALL_N
  syn keyword cConstant AGSI_SUPERSCRIPTS_END
  syn keyword cConstant AGSI_SUBSCRIPTS_BEGIN
  syn keyword cConstant AGSI_SUBSCRIPT_0 AGSI_SUBSCRIPT_1 AGSI_SUBSCRIPT_2
  syn keyword cConstant AGSI_SUBSCRIPT_3 AGSI_SUBSCRIPT_4 AGSI_SUBSCRIPT_5
  syn keyword cConstant AGSI_SUBSCRIPT_6 AGSI_SUBSCRIPT_7 AGSI_SUBSCRIPT_8
  syn keyword cConstant AGSI_SUBSCRIPT_9 AGSI_SUBSCRIPT_PLUS AGSI_SUBSCRIPT_MINUS
  syn keyword cConstant AGSI_SUBSCRIPT_EQUALS AGSI_SUBSCRIPT_L_PAREN
  syn keyword cConstant AGSI_SUBSCRIPT_R_PAREN AGSI_SUBSCRIPT_SMALL_A
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_E AGSI_SUBSCRIPT_SMALL_O
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_X AGSI_SUBSCRIPT_SMALL_H
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_K AGSI_SUBSCRIPT_SMALL_L
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_M AGSI_SUBSCRIPT_SMALL_N
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_P AGSI_SUBSCRIPT_SMALL_S
  syn keyword cConstant AGSI_SUBSCRIPT_SMALL_T
  syn keyword cConstant AGSI_SUBSCRIPTS_END
  syn keyword cConstant AGSI_SUPERSCRIPTS_AND_SUBSCRIPTS_END

  " core/agsi.h (number forms)
  syn keyword cConstant AGSI_NUMBER_FORMS_BEGIN
  syn keyword cConstant AGSI_ROMAN_NUMERAL_1 AGSI_ROMAN_NUMERAL_2
  syn keyword cConstant AGSI_ROMAN_NUMERAL_3 AGSI_ROMAN_NUMERAL_4
  syn keyword cConstant AGSI_ROMAN_NUMERAL_5 AGSI_ROMAN_NUMERAL_6
  syn keyword cConstant AGSI_ROMAN_NUMERAL_7 AGSI_ROMAN_NUMERAL_8
  syn keyword cConstant AGSI_ROMAN_NUMERAL_9 AGSI_ROMAN_NUMERAL_10
  syn keyword cConstant AGSI_ROMAN_NUMERAL_11 AGSI_ROMAN_NUMERAL_12
  syn keyword cConstant AGSI_ROMAN_NUMERAL_50 AGSI_ROMAN_NUMERAL_100
  syn keyword cConstant AGSI_ROMAN_NUMERAL_500 AGSI_ROMAN_NUMERAL_1000
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_1 AGSI_SMALL_ROMAN_NUMERAL_2
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_3 AGSI_SMALL_ROMAN_NUMERAL_4
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_5 AGSI_SMALL_ROMAN_NUMERAL_6
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_7 AGSI_SMALL_ROMAN_NUMERAL_8
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_9 AGSI_SMALL_ROMAN_NUMERAL_10
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_11 AGSI_SMALL_ROMAN_NUMERAL_12
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_50 AGSI_SMALL_ROMAN_NUMERAL_100
  syn keyword cConstant AGSI_SMALL_ROMAN_NUMERAL_500 AGSI_SMALL_ROMAN_NUMERAL_1000
  syn keyword cConstant AGSI_ROMAN_NUMERAL_1000_C_D AGSI_ROMAN_NUMERAL_5000
  syn keyword cConstant AGSI_ROMAN_NUMERAL_10000 AGSI_ROMAN_NUMERAL_REVERSED_100
  syn keyword cConstant AGSI_LATIN_SMALL_REVERSED_C AGSI_ROMAN_NUMERAL_6_LATE_FORM
  syn keyword cConstant AGSI_NUMBER_FORMS_END

  " core/agsi.h (arrows)
  syn keyword cConstant AGSI_ARROWS_BEGIN
  syn keyword cConstant AGSI_L_ARROW AGSI_UP_ARROW AGSI_R_ARROW AGSI_DN_ARROW
  syn keyword cConstant AGSI_LR_ARROW AGSI_UPDN_ARROW 
  syn keyword cConstant AGSI_NW_ARROW AGSI_NE_ARROW AGSI_SE_ARROW AGSI_SW_ARROW
  syn keyword cConstant AGSI_L_ARROW_W_STROKE AGSI_R_ARROW_W_STROKE
  syn keyword cConstant AGSI_L_WAVE_ARROW AGSI_R_WAVE_ARROW
  syn keyword cConstant AGSI_L_TWO_HEADED_ARROW AGSI_UP_TWO_HEADED_ARROW
  syn keyword cConstant AGSI_R_TWO_HEADED_ARROW AGSI_DN_TWO_HEADED_ARROW
  syn keyword cConstant AGSI_L_ARROW_W_TAIL AGSI_R_ARROW_W_TAIL
  syn keyword cConstant AGSI_L_ARROW_FROM_BAR AGSI_UP_ARROW_FROM_BAR
  syn keyword cConstant AGSI_R_ARROW_FROM_BAR AGSI_DN_ARROW_FROM_BAR
  syn keyword cConstant AGSI_UPDN_ARROW_W_BASE AGSI_L_ARROW_W_HOOK AGSI_R_ARROW_W_HOOK 
  syn keyword cConstant AGSI_L_ARROW_W_LOOP AGSI_R_ARROW_W_LOOP AGSI_LR_WAVE_ARROW
  syn keyword cConstant AGSI_LR_ARROW_W_STROKE AGSI_DN_ZIGZAG_ARROW
  syn keyword cConstant AGSI_UP_ARROW_W_TIP_L AGSI_UP_ARROW_W_TIP_R
  syn keyword cConstant AGSI_DN_ARROW_W_TIP_L AGSI_DN_ARROW_W_TIP_R
  syn keyword cConstant AGSI_R_ARROW_W_CORNER_DN AGSI_DN_ARROW_W_CORNER_L
  syn keyword cConstant AGSI_CCW_TOP_SEMICIRCLE_ARROW  AGSI_CW_TOP_SEMICIRCLE_ARROW  
  syn keyword cConstant AGSI_NW_ARROW_TO_LONG_BAR AGSI_L_ARR2BAR_OVER_R_ARR2BAR 
  syn keyword cConstant AGSI_CCW_OPEN_CIRCLE_ARROW AGSI_CW_OPEN_CIRCLE_ARROW 
  syn keyword cConstant AGSI_L_HARPOON_W_BARB_UP AGSI_L_HARPOON_W_BARB_DN  
  syn keyword cConstant AGSI_UP_HARPOON_W_BARB_R AGSI_UP_HARPOON_W_BARB_L 
  syn keyword cConstant AGSI_R_HARPOON_W_BARB_UP AGSI_R_HARPOON_W_BARB_DN 
  syn keyword cConstant AGSI_DN_HARPOON_W_BARB_R AGSI_DN_HARPOON_W_BARB_L 
  syn keyword cConstant AGSI_R_ARROW_OVER_L_ARROW AGSI_UP_ARROW_L_OF_DN_ARROW
  syn keyword cConstant AGSI_L_ARROW_OVER_R_ARROW AGSI_L_PAIRED_ARROWS
  syn keyword cConstant AGSI_UP_PAIRED_ARROWS AGSI_R_PAIRED_ARROWS AGSI_DN_PAIRED_ARROWS
  syn keyword cConstant AGSI_L_HARPOON_OVER_R_HARPOON AGSI_R_HARPOON_OVER_L_HARPOON
  syn keyword cConstant AGSI_L_DOUBLE_ARROW_W_STROKE AGSI_LR_DOUBLE_ARROW_W_STROKE
  syn keyword cConstant AGSI_R_DOUBLE_ARROW_W_STROKE AGSI_L_DOUBLE_ARROW 
  syn keyword cConstant AGSI_UP_DOUBLE_ARROW AGSI_R_DOUBLE_ARROW AGSI_DN_DOUBLE_ARROW
  syn keyword cConstant AGSI_LR_DOUBLE_ARROW AGSI_UPDN_DOUBLE_ARROW
  syn keyword cConstant AGSI_NW_DOUBLE_ARROW AGSI_NE_DOUBLE_ARROW
  syn keyword cConstant AGSI_SE_DOUBLE_ARROW AGSI_SW_DOUBLE_ARROW
  syn keyword cConstant AGSI_L_TRIPLE_ARROW AGSI_R_TRIPLE_ARROW
  syn keyword cConstant AGSI_L_SQUIGGLE_ARROW AGSI_R_SQUIGGLE_ARROW
  syn keyword cConstant AGSI_UP_ARROW_W_DOUBLE_STROKE AGSI_DN_ARROW_W_DOUBLE_STROKE
  syn keyword cConstant AGSI_L_DASHED_ARROW AGSI_UP_DASHED_ARROW
  syn keyword cConstant AGSI_R_DASHED_ARROW AGSI_DN_DASHED_ARROW
  syn keyword cConstant AGSI_L_ARR2BAR AGSI_R_ARR2BAR AGSI_L_WHT_ARROW
  syn keyword cConstant AGSI_UP_WHT_ARROW AGSI_R_WHT_ARROW AGSI_DN_WHT_ARROW
  syn keyword cConstant AGSI_UP_WHT_ARROW_FROM_BAR AGSI_UP_WHT_ARROW_PED
  syn keyword cConstant AGSI_UP_WHT_ARROW_PED_W_HBAR AGSI_UP_WHT_ARROW_PED_W_VBAR
  syn keyword cConstant AGSI_UP_WHT_DOUBLE_ARROW AGSI_UP_WHT_DOUBLE_ARROW_PED
  syn keyword cConstant AGSI_R_WHT_ARROW_FROM_WALL AGSI_NW_ARROW_TO_CORNER
  syn keyword cConstant AGSI_SE_ARROW_TO_CORNER AGSI_UPDN_WHT_ARROW
  syn keyword cConstant AGSI_R_ARROW_W_SMALL_CIRCLE AGSI_DN_ARROW_L_OF_UP_ARROW
  syn keyword cConstant AGSI_THREE_R_ARROWS AGSI_L_ARROW_W_VSTROKE
  syn keyword cConstant AGSI_R_ARROW_W_VSTROKE AGSI_LR_ARROW_W_VSTROKE
  syn keyword cConstant AGSI_L_ARROW_W_DBL_VSTROKE AGSI_R_ARROW_W_DBL_VSTROKE
  syn keyword cConstant AGSI_LR_ARROW_W_DBL_VSTROKE AGSI_L_OPEN_HEADED_ARROW 
  syn keyword cConstant AGSI_R_OPEN_HEADED_ARROW AGSI_LR_OPEN_HEADED_ARROW
  syn keyword cConstant AGSI_ARROWS_END

  " core/agsi.h (mathematical operators)
  syn keyword cConstant AGSI_MATH_OPERATORS_BEGIN
  syn keyword cConstant AGSI_FOR_ALL AGSI_COMPLEMENT AGSI_PARTIAL_DIFFERENTIAL
  syn keyword cConstant AGSI_THERE_EXISTS AGSI_THERE_DOES_NOT_EXIST
  syn keyword cConstant AGSI_EMPTY_SET AGSI_INCREMENT AGSI_NABLA AGSI_ELEMENT_OF
  syn keyword cConstant AGSI_NOT_AN_ELEMENT_OF AGSI_SM_ELEMENT_OF
  syn keyword cConstant AGSI_CONTAINS_AS_MEMBER AGSI_DOES_NOT_CONTAIN_AS_MEMBER
  syn keyword cConstant AGSI_SM_CONTAINS_AS_MEMBER AGSI_END_OF_PROOF
  syn keyword cConstant AGSI_N_ARY_PRODUCT AGSI_N_ARY_COPRODUCT AGSI_N_ARY_SUMMATION
  syn keyword cConstant AGSI_MINUS_SIGN AGSI_MINUS_OR_PLUS_SIGN AGSI_DOT_PLUS
  syn keyword cConstant AGSI_DIVISION_SLASH AGSI_SET_MINUS AGSI_ASTERISK_OPERATOR
  syn keyword cConstant AGSI_RING_OPERATOR AGSI_BULLET_OPERATOR
  syn keyword cConstant AGSI_SQUARE_ROOT AGSI_CUBE_ROOT AGSI_FOURTH_ROOT
  syn keyword cConstant AGSI_PROPORTIONAL_TO AGSI_INFINITY
  syn keyword cConstant AGSI_RIGHT_ANGLE AGSI_ANGLE AGSI_MEASURED_ANGLE
  syn keyword cConstant AGSI_SPHERICAL_ANGLE AGSI_DIVIDES AGSI_DOES_NOT_DIVIDE
  syn keyword cConstant AGSI_PARALLEL_TO AGSI_NOT_PARALLEL_TO AGSI_LOGICAL_AND
  syn keyword cConstant AGSI_LOGICAL_OR AGSI_INTERSECTION AGSI_UNION AGSI_INTEGRAL
  syn keyword cConstant AGSI_DOUBLE_INTEGRAL AGSI_TRIPLE_INTEGRAL AGSI_CONTOUR_INTEGRAL
  syn keyword cConstant AGSI_SURFACE_INTEGRAL AGSI_VOLUME_INTEGRAL AGSI_CW_INTEGRAL
  syn keyword cConstant AGSI_CW_CONTOUR_INTEGRAL AGSI_CCW_CONTOUR_INTEGRAL
  syn keyword cConstant AGSI_THEREFORE AGSI_BECAUSE AGSI_RATIO AGSI_PROPORTION
  syn keyword cConstant AGSI_DOT_MINUS AGSI_EXCESS AGSI_GEOMETRIC_PROPORTION
  syn keyword cConstant AGSI_HOMOTHETIC AGSI_TILDE_OPERATOR AGSI_REVERSED_TILDE
  syn keyword cConstant AGSI_INVERTED_LAZY_S AGSI_SINE_WAVE AGSI_WREATH_PRODUCT
  syn keyword cConstant AGSI_NOT_TILDE AGSI_MINUS_TILDE AGSI_ASYMPTOMATICALLY_EQUAL_TO 
  syn keyword cConstant AGSI_NOT_ASYMPTOMATICALLY_EQUAL_TO AGSI_APPROX_EQUAL_TO
  syn keyword cConstant AGSI_APPROX_BUT_NOT_ACTUALLY_EQUAL_TO
  syn keyword cConstant AGSI_NEITHER_APPROX_NOR_ACTUALLY_EQUAL_TO
  syn keyword cConstant AGSI_ALMOST_EQUAL_TO AGSI_NOT_ALMOST_EQUAL_TO
  syn keyword cConstant AGSI_ALMOST_EQUAL_OR_EQUAL_TO AGSI_TRIPLE_TILDE
  syn keyword cConstant AGSI_EQUIVALENT_TO AGSI_GEOMETRICALLY_EQUIVALENT_TO
  syn keyword cConstant AGSI_DIFFERENCE_BETWEEN AGSI_APPROACHES_THE_LIMIT
  syn keyword cConstant AGSI_GEOMETRICALLY_EQUAL_TO AGSI_APPROX_EQUAL_TO_OR_THE_IMAGE_OF
  syn keyword cConstant AGSI_IMAGE_OF_OR_APPROX_EQUAL_TO AGSI_COLON_EQUALS
  syn keyword cConstant AGSI_EQUALS_COLON AGSI_RING_IN_EQUAL_TO AGSI_RING_EQUAL_TO
  syn keyword cConstant AGSI_CORRESPONDS_TO AGSI_ESTIMATES AGSI_EQUIANGULAR_TO
  syn keyword cConstant AGSI_STAR_EQUALS AGSI_DELTA_EQUAL_TO AGSI_EQUAL_TO_BY_DEFINITION
  syn keyword cConstant AGSI_MEASURED_BY AGSI_QUESTIONED_EQUAL_TO AGSI_NOT_EQUAL_TO
  syn keyword cConstant AGSI_IDENTICAL_TO AGSI_NOT_IDENTICAL_TO
  syn keyword cConstant AGSI_STRICTLY_EQUIVALENT_TO AGSI_LT_OR_EQUAL_TO
  syn keyword cConstant AGSI_GT_OR_EQUAL_TO AGSI_LT_OVER_EQUAL_TO
  syn keyword cConstant AGSI_GT_OVER_EQUAL_TO AGSI_LT_BUT_NOT_EQUAL_TO
  syn keyword cConstant AGSI_GT_BUT_NOT_EQUAL_TO AGSI_MUCH_LT
  syn keyword cConstant AGSI_MUCH_GT AGSI_BETWEEN AGSI_NOT_EQUIVALENT_TO
  syn keyword cConstant AGSI_NOT_LT AGSI_NOT_GT
  syn keyword cConstant AGSI_NEITHER_LT_NOR_EQUAL_TO AGSI_NEITHER_GT_NOR_EQUAL_TO
  syn keyword cConstant AGSI_LT_OR_EQUIVALENT_TO AGSI_GT_OR_EQUIVALENT_TO
  syn keyword cConstant AGSI_LT_OR_GT AGSI_GT_OR_LT
  syn keyword cConstant AGSI_NEITHER_LT_NOR_GT AGSI_NEITHER_GT_NOR_LT
  syn keyword cConstant AGSI_PRECEDES AGSI_SUCCEEDS AGSI_PRECEDES_OR_EQUAL_TO
  syn keyword cConstant AGSI_SUCCEEDS_OR_EQUAL_TO AGSI_PRECEDES_OR_EQUIVALENT_TO
  syn keyword cConstant AGSI_SUCCEEDS_OR_EQUIVALENT_TO AGSI_DOES_NOT_PRECEDE
  syn keyword cConstant AGSI_DOES_NOT_SUCCEED AGSI_SUBSET_OF AGSI_SUBSET_OF
  syn keyword cConstant AGSI_SUPERSET_OF AGSI_NOT_A_SUBSET_OF AGSI_NOT_A_SUPERSET_OF
  syn keyword cConstant AGSI_SUBSET_OF_OR_EQUAL_TO AGSI_SUPERSET_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_NEITHER_A_SUBSET_OF_NOR_EQUAL_TO
  syn keyword cConstant AGSI_NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO
  syn keyword cConstant AGSI_SUBSET_OF_W_NOT_EQUAL_TO AGSI_SUPERSET_OF_W_NOT_EQUAL_TO
  syn keyword cConstant AGSI_MULTISET AGSI_MULTISET_MULTIPLICATION AGSI_MULTISET_UNION
  syn keyword cConstant AGSI_SQUARE_IMAGE_OF AGSI_SQUARE_ORIGINAL_OF
  syn keyword cConstant AGSI_SQUARE_IMAGE_OF_OR_EQUAL_TO AGSI_SQUARE_ORIGINAL_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_SQUARE_CAP AGSI_SQUARE_CUP AGSI_CIRCLED_PLUS
  syn keyword cConstant AGSI_CIRCLED_MINUS AGSI_CIRCLED_TIMES
  syn keyword cConstant AGSI_CIRCLED_DIVISION_SLASH AGSI_CIRCLED_DOT
  syn keyword cConstant AGSI_CIRCLED_RING AGSI_CIRCLED_ASTERISK AGSI_CIRCLED_EQUALS
  syn keyword cConstant AGSI_CIRCLED_DASH AGSI_SQUARED_PLUS AGSI_SQUARED_MINUS
  syn keyword cConstant AGSI_SQUARED_TIMES AGSI_SQUARED_DOT AGSI_R_TACK
  syn keyword cConstant AGSI_L_TACK AGSI_DN_TACK AGSI_UP_TACK AGSI_PERPENDICULAR
  syn keyword cConstant AGSI_ASSERTION AGSI_MODELS AGSI_TRUE_SYMBOL AGSI_FORCES_SYMBOL
  syn keyword cConstant AGSI_TRIPLE_VBAR_R_TURNSTILE AGSI_DOUBLE_VBAR_DOUBLE_R_TURNSTILE
  syn keyword cConstant AGSI_DOES_NOT_PROVE AGSI_NOT_TRUE_SYMBOL AGSI_DOES_NOT_FORCE
  syn keyword cConstant AGSI_NEGATED_DOUBLE_VBAR_DOUBLE_R_TURNSTILE
  syn keyword cConstant AGSI_PRECEDES_UNDER_RELATION AGSI_SUCCEEDS_UNDER_RELATION
  syn keyword cConstant AGSI_NORMAL_SUBGROUP_OF AGSI_CONTAINS_AS_NORMAL_SUBGROUP
  syn keyword cConstant AGSI_NORMAL_SUBGROUP_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO
  syn keyword cConstant AGSI_ORIGINAL_OF AGSI_IMAGE_OF AGSI_MULTIMAP
  syn keyword cConstant AGSI_HERMITIAN_CONJUGATE_MATRIX AGSI_INTERCALATE
  syn keyword cConstant AGSI_XOR_SYMBOL AGSI_NAND_SYMBOL AGSI_NOR_SYMBOL
  syn keyword cConstant AGSI_RIGHT_ANGLE_W_ARC AGSI_RIGHT_TRIANGLE
  syn keyword cConstant AGSI_N_ARY_LOGICAL_AND AGSI_N_ARY_LOGICAL_OR
  syn keyword cConstant AGSI_N_ARY_INTERSECTION AGSI_N_ARY_UNION
  syn keyword cConstant AGSI_DIAMOND_OPERATOR AGSI_DOT_OPERATOR
  syn keyword cConstant AGSI_STAR_OPERATOR AGSI_DIVISION_TIMES AGSI_BOWTIE
  syn keyword cConstant AGSI_L_NORMAL_FACTOR_SEMIDIRECT_PRODUCT
  syn keyword cConstant AGSI_R_NORMAL_FACTOR_SEMIDIRECT_PRODUCT
  syn keyword cConstant AGSI_L_SEMIDIRECT_PRODUCT AGSI_R_SEMIDIRECT_PRODUCT
  syn keyword cConstant AGSI_REVERSED_TILDE_EQUALS AGSI_CURLY_LOGICAL_OR
  syn keyword cConstant AGSI_CURLY_LOGICAL_AND AGSI_DOUBLE_SUBSET
  syn keyword cConstant AGSI_DOUBLE_SUPERSET AGSI_DOUBLE_INTERSECTION
  syn keyword cConstant AGSI_DOUBLE_UNION AGSI_PITCHFORK AGSI_EQUAL_AND_PARALLEL_TO
  syn keyword cConstant AGSI_LT_W_DOT AGSI_GT_W_DOT
  syn keyword cConstant AGSI_VERY_MUCH_LT AGSI_VERY_MUCH_GT
  syn keyword cConstant AGSI_LT_EQUAL_TO_OR_GT
  syn keyword cConstant AGSI_GT_EQUAL_TO_OR_LT
  syn keyword cConstant AGSI_EQUAL_TO_OR_LT AGSI_EQUAL_TO_OR_GT
  syn keyword cConstant AGSI_EQUAL_TO_OR_PRECEDES AGSI_EQUAL_TO_OR_SUCCEEDS
  syn keyword cConstant AGSI_DOES_NOT_PRECEDE_OR_EQUAL AGSI_DOES_NOT_SUCCEED_OR_EQUAL
  syn keyword cConstant AGSI_NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO
  syn keyword cConstant AGSI_SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO
  syn keyword cConstant AGSI_LT_BUT_NOT_EQUIVALENT_TO
  syn keyword cConstant AGSI_GT_BUT_NOT_EQUIVALENT_TO
  syn keyword cConstant AGSI_PRECEDES_BUT_NOT_EQUIVALENT_TO
  syn keyword cConstant AGSI_SUCCEEDS_BUT_NOT_EQUIVALENT_TO
  syn keyword cConstant AGSI_NOT_NORMAL_SUBGROUP_OF
  syn keyword cConstant AGSI_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP
  syn keyword cConstant AGSI_NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO
  syn keyword cConstant AGSI_DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL
  syn keyword cConstant AGSI_VERTICAL_ELLIPSIS AGSI_MIDLINE_HORIZONTAL_ELLIPSIS
  syn keyword cConstant AGSI_UP_R_DIAGONAL_ELLIPSIS AGSI_DN_R_DIAGONAL_ELLIPSIS
  syn keyword cConstant AGSI_ELEMENT_OF_W_LONG_HSTROKE
  syn keyword cConstant AGSI_ELEMENT_OF_W_VBAR_AT_END_OF_HSTROKE
  syn keyword cConstant AGSI_SM_ELEMENT_OF_W_VBAR_AT_END_OF_HSTROKE
  syn keyword cConstant AGSI_ELEMENT_OF_W_DOT_ABOVE
  syn keyword cConstant AGSI_ELEMENT_OF_W_OVERBAR AGSI_SM_ELEMENT_OF_W_OVERBAR
  syn keyword cConstant AGSI_ELEMENT_OF_W_UNDERBAR AGSI_ELEMENT_OF_W_TWO_HSTROKES
  syn keyword cConstant AGSI_CONTAINS_WITH_LONG_HSTROKE
  syn keyword cConstant AGSI_CONTAINS_WITH_VBAR_AT_END_OF_HSTROKE
  syn keyword cConstant AGSI_SM_CONTAINS_WITH_VBAR_AT_END_OF_HSTROKE
  syn keyword cConstant AGSI_SM_CONTAINS_WITH_OVERBAR AGSI_Z_NOTATION_BAG_MEMBERSHIP
  syn keyword cConstant AGSI_MATH_OPERATORS_END

  " core/agsi.h (miscellaneous technical)
  syn keyword cConstant AGSI_MISC_TECH_BEGIN
  syn keyword cConstant AGSI_DIAMETER_SIGN AGSI_ELECTRIC_ARROW AGSI_HOUSE
  syn keyword cConstant AGSI_UP_ARROWHEAD AGSI_DN_ARROWHEAD AGSI_PROJECTIVE
  syn keyword cConstant AGSI_PERSPECTIVE AGSI_WAVY_LINE AGSI_L_CEILING AGSI_R_CEILING
  syn keyword cConstant AGSI_L_FLOOR AGSI_R_FLOOR AGSI_BOTTOM_R_CROP AGSI_BOTTOM_L_CROP
  syn keyword cConstant AGSI_TOP_R_CROP AGSI_TOP_L_CROP AGSI_REVERSED_NOT_SIGN
  syn keyword cConstant AGSI_SQ_LOZENGE AGSI_PLACE_OF_INTEREST_SIGN
  syn keyword cConstant AGSI_TURNED_NOT_SIGN AGSI_TOP_L_CORNER AGSI_TOP_R_CORNER
  syn keyword cConstant AGSI_BOTTOM_L_CORNER AGSI_BOTTOM_R_CORNER
  syn keyword cConstant AGSI_TOP_HALF_INTEGRAL AGSI_BOTTOM_HALF_INTEGRAL
  syn keyword cConstant AGSI_UP_ARROWHEAD_BETWEEN_TWO_HBARS AGSI_OPTION_KEY
  syn keyword cConstant AGSI_ERASE_TO_THE_R AGSI_X_IN_A_RECTANGLE_BOX
  syn keyword cConstant AGSI_KEYBOARD AGSI_ERASE_TO_THE_L AGSI_BENZENE_RING
  syn keyword cConstant AGSI_APL_FUNCTIONAL_SYMBOL_IOTA AGSI_APL_FUNCTIONAL_SYMBOL_RHO
  syn keyword cConstant AGSI_APL_FUNCTIONAL_SYMBOL_OMEGA AGSI_APL_FUNCTIONAL_SYMBOL_ALPHA
  syn keyword cConstant AGSI_SHOULDERED_OPEN_BOX AGSI_ALTERNATIVE_KEY_SYMBOL
  syn keyword cConstant AGSI_SOFTWARE_FUNCTION_SYMBOL AGSI_L_PAREN_UPPER_HOOK
  syn keyword cConstant AGSI_L_PAREN_EXTENSION AGSI_L_PAREN_LOWER_HOOK
  syn keyword cConstant AGSI_R_PAREN_UPPER_HOOK AGSI_R_PAREN_EXTENSION
  syn keyword cConstant AGSI_R_PAREN_LOWER_HOOK AGSI_L_SQ_BRACKET_UPPER_CORNER
  syn keyword cConstant AGSI_L_SQ_BRACKET_EXTENSION AGSI_L_SQ_BRACKET_LOWER_CORNER
  syn keyword cConstant AGSI_R_SQ_BRACKET_UPPER_CORNER AGSI_R_SQ_BRACKET_EXTENSION
  syn keyword cConstant AGSI_R_SQ_BRACKET_LOWER_CORNER AGSI_L_CURLY_BRACKET_UPPER_HOOK
  syn keyword cConstant AGSI_L_CURLY_BRACKET_MIDDLE_PIECE AGSI_L_CURLY_BRACKET_LOWER_HOOK
  syn keyword cConstant AGSI_CURLY_BRACKET_EXTENSION AGSI_R_CURLY_BRACKET_UPPER_HOOK
  syn keyword cConstant AGSI_R_CURLY_BRACKET_MIDDLE_PIECE AGSI_R_CURLY_BRACKET_LOWER_HOOK
  syn keyword cConstant AGSI_INTEGRAL_EXTENSION AGSI_RETURN_SYMBOL AGSI_EJECT_SYMBOL
  syn keyword cConstant AGSI_BENZENE_RING_W_CIRCLE AGSI_FLATNESS
  syn keyword cConstant AGSI_DECIMAL_EXPONENT_SYMBOL AGSI_STOPWATCH
  syn keyword cConstant AGSI_MISC_TECH_END

  " core/agsi.h (control pictures)
  syn keyword cConstant AGSI_CONTROL_PICTURES_BEGIN
  syn keyword cConstant AGSI_BLANK_SYMBOL AGSI_OPEN_BOX
  syn keyword cConstant AGSI_CONTROL_PICTURES_END

  " core/agsi.h (enclosed alphanumerics)
  syn keyword cConstant AGSI_ENCLOSED_ALPHANUMERICS_BEGIN
  syn keyword cConstant AGSI_CIRCLED_DIGIT_1 AGSI_CIRCLED_DIGIT_2 AGSI_CIRCLED_DIGIT_3
  syn keyword cConstant AGSI_CIRCLED_DIGIT_4 AGSI_CIRCLED_DIGIT_5 AGSI_CIRCLED_DIGIT_6
  syn keyword cConstant AGSI_CIRCLED_DIGIT_7 AGSI_CIRCLED_DIGIT_8 AGSI_CIRCLED_DIGIT_9
  syn keyword cConstant AGSI_CIRCLED_DIGIT_10
  syn keyword cConstant AGSI_ENCLOSED_ALPHANUMERICS_END

  " core/agsi.h (geometric shapes)
  syn keyword cConstant AGSI_GEOMETRIC_SHAPES_BEGIN
  syn keyword cConstant AGSI_BLACK_SQUARE AGSI_WHITE_SQUARE
  syn keyword cConstant AGSI_WHITE_SQUARE_W_ROUNDED_CORNERS
  syn keyword cConstant AGSI_WHITE_SQUARE_CONT_BLACK_SM_SQUARE
  syn keyword cConstant AGSI_SQUARE_W_HORIZONTAL_FILL
  syn keyword cConstant AGSI_SQUARE_W_VERTICAL_FILL
  syn keyword cConstant AGSI_SQUARE_W_ORTHOGONAL_CROSSHATCH_FILL
  syn keyword cConstant AGSI_SQUARE_W_UPPER_L_TO_LOWER_R_FILL
  syn keyword cConstant AGSI_SQUARE_W_UPPER_R_TO_LOWER_L_FILL
  syn keyword cConstant AGSI_SQUARE_W_DIAGONAL_CROSSHATCH_FILL
  syn keyword cConstant AGSI_BLACK_SM_SQUARE AGSI_WHITE_SM_SQUARE
  syn keyword cConstant AGSI_BLACK_RECTANGLE AGSI_WHITE_RECTANGLE
  syn keyword cConstant AGSI_BLACK_VERTICAL_RECTANGLE
  syn keyword cConstant AGSI_WHITE_VERTICAL_RECTANGLE
  syn keyword cConstant AGSI_BLACK_PARALLELOGRAM AGSI_WHITE_PARALLELOGRAM
  syn keyword cConstant AGSI_BLACK_UP_POINTING_TRIANGLE
  syn keyword cConstant AGSI_WHITE_UP_POINTING_TRIANGLE
  syn keyword cConstant AGSI_BLACK_UP_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_WHITE_UP_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_BLACK_R_POINTING_TRIANGLE
  syn keyword cConstant AGSI_WHITE_R_POINTING_TRIANGLE
  syn keyword cConstant AGSI_BLACK_R_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_WHITE_R_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_BLACK_R_POINTING_POINTER
  syn keyword cConstant AGSI_WHITE_R_POINTING_POINTER
  syn keyword cConstant AGSI_BLACK_DN_POINTING_TRIANGLE
  syn keyword cConstant AGSI_WHITE_DN_POINTING_TRIANGLE
  syn keyword cConstant AGSI_BLACK_DN_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_WHITE_DN_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_BLACK_L_POINTING_TRIANGLE
  syn keyword cConstant AGSI_WHITE_L_POINTING_TRIANGLE
  syn keyword cConstant AGSI_BLACK_L_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_WHITE_L_POINTING_SM_TRIANGLE
  syn keyword cConstant AGSI_BLACK_L_POINTING_POINTER
  syn keyword cConstant AGSI_WHITE_L_POINTING_POINTER
  syn keyword cConstant AGSI_BLACK_DIAMOND AGSI_WHITE_DIAMOND
  syn keyword cConstant AGSI_WHITE_DIAMOND_CONT_BLACK_SM_DIAMOND
  syn keyword cConstant AGSI_FISHEYE AGSI_LOZENGE AGSI_WHITE_CIRCLE
  syn keyword cConstant AGSI_DOTTED_CIRCLE AGSI_CIRCLE_W_VERTICAL_FILL
  syn keyword cConstant AGSI_BULLSEYE AGSI_BLACK_CIRCLE
  syn keyword cConstant AGSI_CIRCLE_W_L_HALF_BLACK AGSI_CIRCLE_W_R_HALF_BLACK
  syn keyword cConstant AGSI_CIRCLE_W_LOWER_HALF_BLACK
  syn keyword cConstant AGSI_CIRCLE_W_UPPER_HALF_BLACK
  syn keyword cConstant AGSI_CIRCLE_W_UPPER_R_QUADRANT_BLACK
  syn keyword cConstant AGSI_CIRCLE_W_ALL_BUT_UPPER_L_QUADRANT_BLACK
  syn keyword cConstant AGSI_L_HALF_BLACK_CIRCLE AGSI_R_HALF_BLACK_CIRCLE
  syn keyword cConstant AGSI_INVERSE_BULLET AGSI_INVERSE_WHITE_CIRCLE
  syn keyword cConstant AGSI_UPPER_HALF_INVERSE_WHITE_CIRCLE
  syn keyword cConstant AGSI_LOWER_HALF_INVERSE_WHITE_CIRCLE
  syn keyword cConstant AGSI_UPPER_L_QUADRANT_CIRCULAR_ARC
  syn keyword cConstant AGSI_UPPER_R_QUADRANT_CIRCULAR_ARC
  syn keyword cConstant AGSI_LOWER_R_QUADRANT_CIRCULAR_ARC
  syn keyword cConstant AGSI_LOWER_L_QUADRANT_CIRCULAR_ARC
  syn keyword cConstant AGSI_UPPER_HALF_CIRCLE AGSI_LOWER_HALF_CIRCLE
  syn keyword cConstant AGSI_BLACK_LOWER_R_TRIANGLE AGSI_BLACK_LOWER_L_TRIANGLE
  syn keyword cConstant AGSI_BLACK_UPPER_L_TRIANGLE AGSI_BLACK_UPPER_R_TRIANGLE
  syn keyword cConstant AGSI_WHITE_BULLET
  syn keyword cConstant AGSI_SQUARE_W_L_HALF_BLACK AGSI_SQUARE_W_R_HALF_BLACK
  syn keyword cConstant AGSI_SQUARE_W_UPPER_L_DIAGONAL_HALF_BLACK
  syn keyword cConstant AGSI_SQUARE_W_LOWER_R_DIAGONAL_HALF_BLACK
  syn keyword cConstant AGSI_SQUARE_W_VERTICAL_BISECTING_LINE
  syn keyword cConstant AGSI_WHITE_UP_POINTING_TRIANGLE_W_DOT
  syn keyword cConstant AGSI_UP_POINTING_TRIANGLE_W_L_HALF_BLACK
  syn keyword cConstant AGSI_UP_POINTING_TRIANGLE_W_R_HALF_BLACK
  syn keyword cConstant AGSI_LARGE_CIRCLE
  syn keyword cConstant AGSI_WHITE_SQUARE_W_UPPER_L_QUADRANT
  syn keyword cConstant AGSI_WHITE_SQUARE_W_LOWER_L_QUADRANT
  syn keyword cConstant AGSI_WHITE_SQUARE_W_LOWER_R_QUADRANT
  syn keyword cConstant AGSI_WHITE_SQUARE_W_UPPER_R_QUADRANT
  syn keyword cConstant AGSI_WHITE_CIRCLE_W_UPPER_L_QUADRANT
  syn keyword cConstant AGSI_WHITE_CIRCLE_W_LOWER_L_QUADRANT
  syn keyword cConstant AGSI_WHITE_CIRCLE_W_LOWER_R_QUADRANT
  syn keyword cConstant AGSI_WHITE_CIRCLE_W_UPPER_R_QUADRANT
  syn keyword cConstant AGSI_UPPER_L_TRIANGLE AGSI_UPPER_R_TRIANGLE
  syn keyword cConstant AGSI_LOWER_L_TRIANGLE
  syn keyword cConstant AGSI_WHITE_MEDIUM_SQUARE AGSI_BLACK_MEDIUM_SQUARE
  syn keyword cConstant AGSI_WHITE_MEDIUM_SM_SQUARE AGSI_BLACK_MEDIUM_SM_SQUARE
  syn keyword cConstant AGSI_LOWER_R_TRIANGLE AGSI_BLACK_SUN_W_RAYS AGSI_CLOUD
  syn keyword cConstant AGSI_UMBRELLA AGSI_SNOWMAN AGSI_COMET AGSI_BLACK_STAR
  syn keyword cConstant AGSI_WHITE_STAR AGSI_LIGHTNING AGSI_THUNDERSTORM
  syn keyword cConstant AGSI_SUN AGSI_ASCENDING_NODE AGSI_DESCENDING_NODE
  syn keyword cConstant AGSI_CONJUNCTION AGSI_OPPOSITION AGSI_BLACK_TELEPHONE
  syn keyword cConstant AGSI_WHITE_TELEPHONE AGSI_BALLOT_BOX
  syn keyword cConstant AGSI_BALLOT_BOX_W_CHECK AGSI_BALLOT_BOX_W_X AGSI_SALTIRE
  syn keyword cConstant AGSI_UMBRELLA_W_RAIN_DROPS AGSI_HOT_BEVERAGE
  syn keyword cConstant AGSI_WHITE_SHOGI_PIECE AGSI_BLACK_SHOGI_PIECE
  syn keyword cConstant AGSI_SHAMROCK
  syn keyword cConstant AGSI_REVERSED_ROTATED_FLORAL_HEART_BULLET
  syn keyword cConstant AGSI_BLACK_L_POINTING_INDEX AGSI_BLACK_R_POINTING_INDEX
  syn keyword cConstant AGSI_WHITE_L_POINTING_INDEX AGSI_WHITE_UP_POINTING_INDEX
  syn keyword cConstant AGSI_WHITE_R_POINTING_INDEX AGSI_WHITE_DN_POINTING_INDEX
  syn keyword cConstant AGSI_SKULL_AND_CROSSBONES AGSI_CAUTION_SIGN
  syn keyword cConstant AGSI_RADIOACTIVE_SIGN AGSI_BIOHAZARD_SIGN AGSI_CADUCEUS
  syn keyword cConstant AGSI_ANKH AGSI_ORTHODOX_CROSS AGSI_CHI_RHO
  syn keyword cConstant AGSI_CROSS_OF_LORRAINE AGSI_CROSS_OF_JERUSALEM
  syn keyword cConstant AGSI_STAR_AND_CRESCENT AGSI_FARSI_SYMBOL
  syn keyword cConstant AGSI_ADI_SHAKTI AGSI_HAMMER_AND_SICKLE
  syn keyword cConstant AGSI_PEACE_SYMBOL AGSI_YIN_YANG

  syn keyword cConstant AGSI_GEOMETRIC_SHAPES_END

  " core/agsi.h (miscellaneous symbols)
  syn keyword cConstant AGSI_MISC_SYMBOLS_BEGIN
  syn keyword cConstant AGSI_LIGHTNING
  syn keyword cConstant AGSI_WHEEL_OF_DHARMA AGSI_SCALES AGSI_GEAR
  syn keyword cConstant AGSI_WHEELCHAIR_SYMBOL
  syn keyword cConstant AGSI_MISC_SYMBOLS_END

  " core/agsi.h (dingbats)
  syn keyword cConstant AGSI_DINGBATS_BEGIN
  syn keyword cConstant AGSI_VICTORY_HAND AGSI_WRITING_HAND AGSI_LOWER_R_PENCIL
  syn keyword cConstant AGSI_PENCIL AGSI_UPPER_RIGHT_PENCIL AGSI_WHITE_NIB
  syn keyword cConstant AGSI_BLACK_NIB AGSI_CHECK_MARK AGSI_HEAVY_CHECK_MARK
  syn keyword cConstant AGSI_MULTIPLICATION_X AGSI_HEAVY_MULTIPLICATION_X
  syn keyword cConstant AGSI_BALLOT_X AGSI_HEAVY_BALLOT_X
  syn keyword cConstant AGSI_BLK_4_POINTED_STAR AGSI_WHT_4_POINTED_STAR
  syn keyword cConstant AGSI_CCW_CLOSED_CIRCLE_ARROW AGSI_CW_CLOSED_CIRCLE_ARROW
  syn keyword cConstant AGSI_DINGBATS_END

  " core/agsi.h (miscellaneous symbols and pictographs)
  syn keyword cConstant AGSI_MISC_SYM_AND_PIC_BEGIN
  syn keyword cConstant AGSI_NEW_MOON AGSI_WAXING_CRESCENT_MOON
  syn keyword cConstant AGSI_FIRST_QUARTER_MOON AGSI_WAXING_GIBBOUS_MOON
  syn keyword cConstant AGSI_FULL_MOON AGSI_WANING_GIBBOUS_MOON
  syn keyword cConstant AGSI_LAST_QUARTER_MOON AGSI_WANING_CRESCENT_MOON
  syn keyword cConstant AGSI_ARTISTS_PALETTE
  syn keyword cConstant AGSI_ANT AGSI_MOUSE_FACE AGSI_COW_FACE AGSI_CAT_FACE
  syn keyword cConstant AGSI_MONKEY_FACE AGSI_TEE_SHIRT AGSI_JEANS
  syn keyword cConstant AGSI_PILE_OF_POO AGSI_FLOPPY_DISK AGSI_DVD AGSI_CAMERA
  syn keyword cConstant AGSI_SPKR_W_3_SOUND_WAVES AGSI_JOYSTICK AGSI_LOWER_L_PENCIL
  syn keyword cConstant AGSI_TWO_BUTTON_MOUSE
  syn keyword cConstant AGSI_MISC_SYM_AND_PIC_END

  " core/agsi.h (emoticons)
  syn keyword cConstant AGSI_EMOTICONS_BEGIN
  syn keyword cConstant AGSI_GRINNING_FACE AGSI_GRINNING_FACE_W_SML_EYES
  syn keyword cConstant AGSI_FACE_W_TEARS_OF_JOY AGSI_SML_FACE_W_OM
  syn keyword cConstant AGSI_SML_FACE_W_OM_AND_SML_EYES
  syn keyword cConstant AGSI_SML_FACE_W_OM_AND_COLD_SWEAT
  syn keyword cConstant AGSI_SML_FACE_W_OM_AND_CLOSED_EYES
  syn keyword cConstant AGSI_SML_FACE_W_HALO AGSI_SML_FACE_W_HORNS
  syn keyword cConstant AGSI_WINKING_FACE AGSI_SML_FACE_W_SML_EYES
  syn keyword cConstant AGSI_FACE_SAVORING_DELICIOUS_FOOD AGSI_RELIEVED_FACE
  syn keyword cConstant AGSI_SML_FACE_W_HEART_SHAPED_EYES AGSI_SML_FACE_W_SUNGLASSES
  syn keyword cConstant AGSI_SMIRKING_FACE AGSI_NEUTRAL_FACE AGSI_EXPRESSIONLESS_FACE
  syn keyword cConstant AGSI_UNAMUSED_FACE AGSI_FACE_W_COLD_SWEAT AGSI_PENSIVE_FACE
  syn keyword cConstant AGSI_CONFUSED_FACE AGSI_CONFOUNDED_FACE AGSI_KISSING_FACE
  syn keyword cConstant AGSI_FACE_THROWING_A_KISS AGSI_KISSING_FACE_W_SML_EYES
  syn keyword cConstant AGSI_KISSING_FACE_W_CLOSED_EYES
  syn keyword cConstant AGSI_FACE_W_TONGUE
  syn keyword cConstant AGSI_FACE_W_TONGUE_AND_WINKING_EYE
  syn keyword cConstant AGSI_FACE_W_TONGUE_AND_CLOSED_EYES
  syn keyword cConstant AGSI_DISAPPOINTED_FACE AGSI_WORRIED_FACE AGSI_ANGRY_FACE
  syn keyword cConstant AGSI_POUTING_FACE AGSI_CRYING_FACE AGSI_PERSEVERING_FACE
  syn keyword cConstant AGSI_FACE_W_LOOK_OF_TRIUMPH AGSI_DISAPPOINTED_BUT_RELIEVED_FACE
  syn keyword cConstant AGSI_FROWNING_FACE_W_OM AGSI_ANGUISHED_FACE
  syn keyword cConstant AGSI_FEARFUL_FACE AGSI_WEARY_FACE AGSI_SLEEPY_FACE
  syn keyword cConstant AGSI_TIRED_FACE AGSI_GRIMACING_FACE AGSI_LOUDLY_CRYING_FACE
  syn keyword cConstant AGSI_FACE_W_OM AGSI_HUSHED_FACE AGSI_FACE_W_OM_AND_COLD_SWEAT
  syn keyword cConstant AGSI_FACE_SCREAMING_IN_FEAR AGSI_ASTONISHED_FACE
  syn keyword cConstant AGSI_FLUSHED_FACE AGSI_SLEEPING_FACE AGSI_DIZZY_FACE
  syn keyword cConstant AGSI_FACE_WO_MOUTH AGSI_FACE_MEDICAL_MASK
  syn keyword cConstant AGSI_GRINNING_CAT_FACE_W_SML_EYES AGSI_CAT_FACE_W_TEARS_OF_JOY
  syn keyword cConstant AGSI_SML_CAT_FACE_W_OM AGSI_SML_CAT_FACE_W_HEART_SHAPED_EYES
  syn keyword cConstant AGSI_CAT_FACE_W_WRY_SMILE AGSI_KISSING_CAT_FACE_W_CLOSED_EYES
  syn keyword cConstant AGSI_POUTING_CAT_FACE AGSI_CRYING_CAT_FACE AGSI_WEARY_CAT_FACE
  syn keyword cConstant AGSI_UPSIDE_DOWN_FACE AGSI_CONSTRUCTION_SIGN
  syn keyword cConstant AGSI_EMOTICONS_END

  " core/agsi.h (Agar Ideograms)
  syn keyword cConstant AGSI_AGARIDEO_BEGIN
  syn keyword cConstant AGSI_BLACK_AGAR AGSI_WHITE_AGAR AGSI_MENUBOOL_TRUE
  syn keyword cConstant AGSI_MENUBOOL_FALSE AGSI_KEYMOD_HYPHEN AGSI_MENU_EXPANDER
  syn keyword cConstant AGSI_BOX_VERT AGSI_BOX_HORIZ AGSI_BUTTON AGSI_BEZIER
  syn keyword cConstant AGSI_CHARSETS AGSI_CHECKBOX AGSI_WINDOW_GRADIENT
  syn keyword cConstant AGSI_CONSOLE AGSI_CUSTOM_WIDGET AGSI_FIXED_LAYOUT
  syn keyword cConstant AGSI_WIDGET_FOCUS AGSI_TYPOGRAPHY AGSI_FILESYSTEM
  syn keyword cConstant AGSI_WIREFRAME_CUBE AGSI_LOAD_IMAGE AGSI_SAVE_IMAGE
  syn keyword cConstant AGSI_KEYBOARD_KEY AGSI_MATH_X_EQUALS AGSI_V_MAXIMIZE
  syn keyword cConstant AGSI_H_MAXIMIZE AGSI_MEDIUM_WINDOW AGSI_SMALL_WINDOW
  syn keyword cConstant AGSI_SMALL_SPHERE AGSI_LARGE_SPHERE AGSI_WINDOW_PANE
  syn keyword cConstant AGSI_RADIO_BUTTON AGSI_RENDER_TO_SURFACE
  syn keyword cConstant AGSI_HORIZ_SCROLLBAR AGSI_VERT_SCROLLBAR AGSI_SCROLLVIEW
  syn keyword cConstant AGSI_SWORD AGSI_NUL_TERMINATION AGSI_TABLE AGSI_TEXTBOX
  syn keyword cConstant AGSI_PROGRESS_BAR AGSI_CANNED_DIALOG AGSI_THREADS
  syn keyword cConstant AGSI_EMPTY_HOURGLASS AGSI_UNIT_CONVERSION AGSI_USER_ACCESS
  syn keyword cConstant AGSI_POPULATED_WINDOW AGSI_TWO_WINDOWS
  syn keyword cConstant AGSI_UNUSED_1 AGSI_UNUSED_2 AGSI_USER_W_3_SOUND_WAVES
  syn keyword cConstant AGSI_FOLDED_DIAPER AGSI_UNFOLDED_DIAPER AGSI_PAPER_ROLL
  syn keyword cConstant AGSI_CONTAINER AGSI_PARCEL AGSI_WAREHOUSE AGSI_FORKLIFT
  syn keyword cConstant AGSI_TRANSPORT_DRUM AGSI_UNUSED_3 AGSI_UNUSED_4 AGSI_UNUSED_5
  syn keyword cConstant AGSI_UNUSED_6 AGSI_UNUSED_7 AGSI_CLOSE_X AGSI_EXPORT_DOCUMENT
  syn keyword cConstant AGSI_PAD AGSI_DEBUGGER AGSI_L_MENU_EXPANDER
  syn keyword cConstant AGSI_USB_STICK AGSI_VERTICAL_SPOOL AGSI_HORIZONTAL_SPOOL
  syn keyword cConstant AGSI_DIP_CHIP AGSI_SURFACE_MOUNT_CHIP AGSI_VACUUM_TUBE
  syn keyword cConstant AGSI_ELECTRON_TUBE AGSI_ZOOM_IN AGSI_ZOOM_OUT
  syn keyword cConstant AGSI_ZOOM_RESET AGSI_AGAR_AG AGSI_AGAR_AR AGSI_CUT
  syn keyword cConstant AGSI_COPY AGSI_LH_COPY AGSI_CLIPBOARD AGSI_PASTE
  syn keyword cConstant AGSI_LH_PASTE AGSI_SELECT_ALL AGSI_CLEAR_ALL
  syn keyword cConstant AGSI_GAME_CONTROLLER AGSI_TOUCHSCREEN
  syn keyword cConstant AGSI_TRI_CONSTRUCTION_SIGN AGSI_EDGAR_ALLAN_POE
  syn keyword cConstant AGSI_AGARIAN AGSI_PAPIGROW AGSI_AGARIAN_WARRIOR
  syn keyword cConstant AGSI_POWERFUL_AGAR AGSI_UNDO AGSI_REDO AGSI_ALPHA_ARCH
  syn keyword cConstant AGSI_AMIGA_BALL AGSI_COMMODORE_LOGO AGSI_AMD_LOGO
  syn keyword cConstant AGSI_6502_ARCH AGSI_AMIGA_LOGO AGSI_MOTOROLA_LOGO
  syn keyword cConstant AGSI_MAMISMOKE AGSI_TGT_FG_COLOR AGSI_TGT_BG_COLOR
  syn keyword cConstant AGSI_ARM_ARCH AGSI_DREAMCAST AGSI_GAMECUBE AGSI_SEGA
  syn keyword cConstant AGSI_PA_RISC_ARCH AGSI_X86_ARCH AGSI_X64_ARCH
  syn keyword cConstant AGSI_I386_ARCH AGSI_JSON AGSI_NES_CONTROLLER
  syn keyword cConstant AGSI_MIPS32_ARCH AGSI_MIPS64_ARCH AGSI_N64_LOGO
  syn keyword cConstant AGSI_IA64_ARCH AGSI_PPC32_ARCH AGSI_PPC64_ARCH
  syn keyword cConstant AGSI_SNES_LOGO AGSI_RISCV_ARCH AGSI_HORIZONTAL_RULE
  syn keyword cConstant AGSI_VERTICAL_RULE AGSI_MEASURED_AREA AGSI_MEASURED_VOLUME
  syn keyword cConstant AGSI_MEASURED_TEMP AGSI_PRESSURE_GAUGE
  syn keyword cConstant AGSI_BELL_JAR AGSI_BELL_JAR_W_VACUUM AGSI_BELL_JAR_W_PRESSURE
  syn keyword cConstant AGSI_VERTEX AGSI_WHITE_POLYGON AGSI_WHITE_OCTAGON
  syn keyword cConstant AGSI_VOXEL AGSI_OPENGL AGSI_GLX AGSI_XORG AGSI_SDL
  syn keyword cConstant AGSI_SDL2 AGSI_APPLE_LOGO AGSI_COFFEE_BEAN
  syn keyword cConstant AGSI_MATRIX_A AGSI_MATRIX_B AGSI_NULL_MATRIX
  syn keyword cConstant AGSI_IDENTITY_MATRIX AGSI_TOOLBAR AGSI_SHUFFLE
  syn keyword cConstant AGSI_AGARIDEO_END
endif

if !exists("c_no_agar_core") || exists("c_agar_core_typedefs")
  " core/agtime.h
  syn keyword cType AG_Timer AG_TimerFn AG_TimerPvt AG_TimeOps
  syn keyword cConstant AG_TIMER_NAME_MAX AG_TIMER_SURVIVE_DETACH
  syn keyword cConstant AG_TIMER_AUTO_FREE AG_TIMER_EXECD AG_TIMER_RESTART

  " core/begin.h
  syn keyword cConstant AG_INLINE AG_NULL

  " core/classes.h
  syn keyword cType AG_Class
  syn keyword cConstant AGC_OBJECT AGC_CONFIG AGC_DB AGC_DB_HASH AGC_DB_MYSQL
  syn keyword cConstant AGC_DB_OBJECT AGC_DB_BTREE
  syn keyword cConstant AGC_DRIVER_SW AGC_DRIVER_MW AGC_DRIVER AGC_DRIVER_C64
  syn keyword cConstant AGC_DRIVER_SDLGL AGC_DRIVER_SDLFB AG_DRIVER_DUMMY
  syn keyword cConstant AGC_DRIVER_SDL2GL AGC_DRIVER_SDL2FB AGC_DRIVER_COCOA
  syn keyword cConstant AGC_DRIVER_WGL AGC_DRIVER_GLX
  syn keyword cConstant AGC_DRIVER_SDL2MW AGC_DRIVER_DUMMY
  syn keyword cConstant AGC_INPUT_DEVICE AGC_MOUSE AGC_KEYBOARD AGC_JOYSTICK
  syn keyword cConstant AGC_CONTROLLER AGC_FONT AGC_FONT_BF AGC_FONT_FT
  syn keyword cConstant AGC_WIDGET
  syn keyword cConstant AGC_WINDOW AGC_BOX AGC_BOX_HORIZ AGC_BOX_VERT
  syn keyword cConstant AGC_MPANE AGC_NOTEBOOK_TAB
  syn keyword cConstant AGC_STATUSBAR AGC_TITLEBAR AGC_TOOLBAR AGC_BUTTON
  syn keyword cConstant AGC_CHECKBOX AGC_COMBO AGC_OBJECT_SELECTOR AGC_CONSOLE
  syn keyword cConstant AGC_EDITABLE AGC_DIR_DLG AGC_FONT_SELECTOR AGC_FILE_DLG
  syn keyword cConstant AGC_FIXED AGC_FIXED_PLOTTER AGC_GRAPH AGC_GLVIEW
  syn keyword cConstant AGC_HSVPAL AGC_ICON AGC_LABEL AGC_MENU AGC_MENUVIEW
  syn keyword cConstant AGC_MFSPINBUTTON AGC_MSPINBUTTON AGC_NOTEBOOK
  syn keyword cConstant AGC_NUMERICAL AGC_PANE AGC_PIXMAP AGC_PROGRESSBAR
  syn keyword cConstant AGC_RADIO AGC_SCROLLBAR AGC_SCROLLVIEW AGC_SEPARATOR
  syn keyword cConstant AGC_SLIDER AGC_SOCKET AGC_TABLE AGC_TREETBL AGC_TEXTBOX
  syn keyword cConstant AGC_TLIST AGC_UCOMBO AGC_VG_VIEW AGC_MAP_VIEW 
  syn keyword cConstant AGC_MAP_OBJECT AGC_RG_TILESET AGC_VG AGC_MAP
  syn keyword cConstant AGC_RG_TILEVIEW AGC_SK_VIEW AGC_SG AGC_SG_NODE
  syn keyword cConstant AGC_SG_PROGRAM AGC_SG_TEXTURE AGC_SG_PALETTE AGC_SG_SCRIPT
  syn keyword cConstant AGC_SG_DUMMY AGC_SG_CAMERA AGC_SG_LIGHT AGC_SG_GEOM
  syn keyword cConstant AGC_SG_WIDGET AGC_SG_POINT AGC_SG_LINE AGC_SG_CIRCLE
  syn keyword cConstant AGC_SG_SPHERE AGC_SG_PLANE AGC_SG_POLYGON AGC_SG_TRIANGLE
  syn keyword cConstant AGC_SG_RECTANGLE AGC_SG_OBJECT AGC_SG_POLYBALL
  syn keyword cConstant AGC_SG_POLYBOX AGC_SG_VOXEL AGC_SG_IMAGE AGC_SG_CG_PROGRAM
  syn keyword cConstant AGC_SG_VIEW AGC_SK AGC_M_PLOTTER AGC_M_MATVIEW
  syn keyword cConstant AGC_WIDGET_LAST

  " core/config.h
  syn keyword cType AG_Config AG_ConfigPathGroup AG_ConfigPath AG_ConfigPathQ
  syn keyword cConstant AG_CONFIG_PATH_DATA AG_CONFIG_PATH_FONTS
  syn keyword cConstant AG_CONFIG_PATH_TEMP AG_CONFIG_PATH_LAST
  " core/core.h
  syn keyword cConstant AG_BYTEORDER AG_BIG_ENDIAN AG_LITTLE_ENDIAN
  " core/core_init.h
  syn keyword cConstant AG_VERBOSE AG_CREATE_DATADIR AG_SOFT_TIMERS
  syn keyword cConstant AG_POSIX_USERS AG_MEMORY_MODEL_NAME
  syn keyword cConstant AG_PATHSEP AG_PATHSEPCHAR AG_PATHSEPMULTI
  " core/cpuinfo.h
  syn keyword cType AG_CPUInfo
  syn keyword cConstant AG_EXT_CPUID AG_EXT_MMX AG_EXT_MMX_EXT AG_EXT_3DNOW
  syn keyword cConstant AG_EXT_3DNOW_EXT AG_EXT_ALTIVEC AG_EXT_SSE AG_EXT_SSE2 
  syn keyword cConstant AG_EXT_SSE3 AG_EXT_LONG_MODE AG_EXT_RDTSCP AG_EXT_FXSR 
  syn keyword cConstant AG_EXT_PAGE_NX AG_EXT_SSE5A AG_EXT_3DNOW_PREFETCH
  syn keyword cConstant AG_EXT_SSE_MISALIGNED AG_EXT_SSE4A AG_EXT_ONCHIP_FPU
  syn keyword cConstant AG_EXT_TSC AG_EXT_CMOV AG_EXT_CLFLUSH AG_EXT_HTT
  syn keyword cConstant AG_EXT_MON AG_EXT_VMX AG_EXT_SSSE3 AG_EXT_SSE41
  syn keyword cConstant AG_EXT_SSE42
  " core/data_source.h
  syn keyword cType AG_ByteOrder AG_DataSource AG_FileSource AG_CoreSource
  syn keyword cType AG_ConstCoreSource AG_NetSocketSource
  syn keyword cConstant AG_BYTEORDER_BE AG_BYTEORDER_LE AG_SEEK_SET AG_SEEK_CUR
  syn keyword cConstant AG_SEEK_END AG_SOURCE_UINT8 AG_SOURCE_SINT8
  syn keyword cConstant AG_SOURCE_UINT16 AG_SOURCE_SINT16 AG_SOURCE_UINT32
  syn keyword cConstant AG_SOURCE_SINT32 AG_SOURCE_UINT64 AG_SOURCE_SINT64 
  syn keyword cConstant AG_SOURCE_FLOAT AG_SOURCE_DOUBLE AG_SOURCE_LONG_DOUBLE 
  syn keyword cConstant AG_SOURCE_STRING AG_SOURCE_COLOR_RGBA AG_SOURCE_STRING_PAD
  " core/db.h
  syn keyword cType AG_Db AG_DbClass AG_Dbt AG_DbEntry AG_DbHashBT AG_DbMySQL
  syn keyword cType AG_Db AG_DbIterateFn
  syn keyword cConstant AG_DB_KEY_DATA AG_DB_KEY_NUMBER AG_DB_KEY_STRING
  syn keyword cConstant AG_DB_REC_VARIABLE AG_DB_REC_FIXED AG_DB_OPEN AG_DB_READONLY
  " core/dbobject.h
  syn keyword cType AG_DbObject
  " core/dir.h
  syn keyword cType AG_Dir
  " core/dso.h
  syn keyword cType AG_DSOSym AG_DSO AG_DSO_BeOS AG_DSO_OS2 AG_DSO_Generic
  syn keyword cConstant AG_DSONAME_MAX
  " core/error.h
  syn keyword cType AG_ErrorCode
  syn keyword cConstant AG_EUNDEFINED AG_EPERM AG_ENOENT AG_EINTR AG_EIO AG_E2BIG 
  syn keyword cConstant AG_EACCESS AG_EBUSY AG_EEXIST AG_ENOTDIR AG_EISDIR 
  syn keyword cConstant AG_EMFILE AG_EFBIG AG_ENOSPC AG_EROFS AG_EAGAIN
  " core/event.h
  syn keyword cType AG_Event AG_EventFn AG_Function AG_EventSource AG_EventSink
  syn keyword cType AG_VecVoid AG_VecString AG_VecInt AG_VecChar AG_VecFloat 
  syn keyword cType AG_VecDouble
  syn keyword cConstant AG_SINK_NONE AG_SINK_PROLOGUE AG_SINK_EPILOGUE
  syn keyword cConstant AG_SINK_SPINNER AG_SINK_TERMINATOR AG_SINK_TIMER
  syn keyword cConstant AG_SINK_READ AG_SINK_WRITE AG_SINK_FSEVENT AG_SINK_PROCEVENT
  syn keyword cConstant AG_SINK_LAST AG_EVENT_ARGS_MAX AG_EVENT_NAME_MAX
  syn keyword cConstant AG_FSEVENT_DELETE AG_FSEVENT_WRITE AG_FSEVENT_EXTEND
  syn keyword cConstant AG_FSEVENT_ATTRIB AG_FSEVENT_LINK AG_FSEVENT_RENAME
  syn keyword cConstant AG_FSEVENT_REVOKE AG_PROCEVENT_EXIT AG_PROCEVENT_FORK
  syn keyword cConstant AG_PROCEVENT_EXEC
  " core/event.c
  syn keyword cType AG_EventSourceKQUEUE
  " core/exec.h
  syn keyword cConstant AG_EXEC_WAIT_IMMEDIATE AG_EXEC_WAIT_INFINITE
  " core/file.h
  syn keyword cType AG_FileInfo AG_FileExtMapping
  syn keyword cConstant AG_FILE_REGULAR AG_FILE_DIRECTORY AG_FILE_DEVICE
  syn keyword cConstant AG_FILE_FIFO AG_FILE_SYMLINK AG_FILE_SOCKET
  syn keyword cConstant AG_FILE_READABLE AG_FILE_WRITEABLE AG_FILE_EXECUTABLE
  syn keyword cConstant AG_FILE_SUID AG_FILE_SGID AG_FILE_ARCHIVE 
  syn keyword cConstant AG_FILE_HIDDEN AG_FILE_TEMPORARY AG_FILE_SYSTEM
  " core/ag_limits.h
  syn keyword cConstant AG_FILENAME_MAX AG_PATHNAME_MAX AG_ARG_MAX AG_BUFFER_MIN 
  syn keyword cConstant AG_BUFFER_MAX AG_INT_MIN AG_INT_MAX AG_UINT_MIN
  syn keyword cConstant AG_UINT_MAX AG_FLT_MIN AG_FLT_MAX AG_DBL_MIN AG_DBL_MAX
  syn keyword cConstant AG_LDBL_MIN AG_LDBL_MAX AG_LONG_MIN AG_LONG_MAX AG_ULONG_MIN 
  syn keyword cConstant AG_ULONG_MAX AG_ULLONG_MAX AG_LLONG_MIN AG_LLONG_MAX
  syn keyword cConstant AG_FLT_EPSILON AG_DBL_EPSILON
  " core/load_string.h
  syn keyword cType AG_FmtStringExtFn AG_FmtStringExt
  syn keyword cConstant AG_LOAD_STRING_MAX
  " core/load_version.h
  syn keyword cType AG_Version
  " core/object.h
  syn keyword cType AG_Object AG_ObjectHeader AG_ObjectClass
  syn keyword cType AG_ObjectClassSpec AG_ObjectInitFn
  syn keyword cType AG_ObjectResetFn AG_ObjectDestroyFn AG_ObjectLoadFn
  syn keyword cType AG_ObjectSaveFn AG_ObjectEditFn AG_Namespace
  syn keyword cConstant AG_OBJECT_NAME_MAX AG_OBJECT_TYPE_MAX AG_OBJECT_HIER_MAX 
  syn keyword cConstant AG_OBJECT_PATH_MAX AG_OBJECT_LIBS_MAX AG_OBJECT_CLASSTBLSIZE
  syn keyword cConstant AG_OBJECT_MAX_VARIABLES AG_OBJECT_TYPE_TAG AG_OBJECT_TYPE_TAG_LEN
  syn keyword cConstant AG_OBJECT_STATIC AG_OBJECT_INDESTRUCTIBLE
  syn keyword cConstant AG_OBJECT_READONLY AG_OBJECT_DEBUG
  syn keyword cConstant AG_OBJECT_NAME_ONATTACH AG_OBJECT_DEBUG_DATA
  syn keyword cConstant AG_OBJECT_BOUND_EVENTS AG_OBJECT_SAVED_FLAGS
  " core/queue.h
  syn keyword cConstant AG_SLIST_HEAD AG_SLIST_HEAD_ AG_SLIST_ENTRY
  syn keyword cConstant AG_LIST_HEAD AG_LIST_HEAD_ AG_LIST_ENTRY
  syn keyword cConstant AG_SIMPLEQ_HEAD AG_SIMPLEQ_HEAD_ AG_SIMPLEQ_ENTRY
  syn keyword cConstant AG_TAILQ_HEAD AG_TAILQ_HEAD_ AG_TAILQ_ENTRY
  syn keyword cConstant AG_CIRCLEQ_HEAD AG_CIRCLEQ_HEAD_ AG_CIRCLEQ_ENTRY
  syn keyword cConstant SLIST_HEAD SLIST_HEAD_ SLIST_ENTRY
  syn keyword cConstant LIST_HEAD LIST_HEAD_ LIST_ENTRY
  syn keyword cConstant SIMPLEQ_HEAD SIMPLEQ_HEAD_ SIMPLEQ_ENTRY
  syn keyword cConstant TAILQ_HEAD TAILQ_HEAD_ TAILQ_ENTRY
  syn keyword cConstant CIRCLEQ_HEAD CIRCLEQ_HEAD_ CIRCLEQ_ENTRY
  " core/options.h
  syn keyword cConstant AG_ANSI_COLOR AG_DEBUG AG_ENABLE_DSO AG_ENABLE_EXEC
  syn keyword cConstant AG_ENABLE_STRING AG_EVENT_LOOP AG_LEGACY AG_NAMED_ARGS
  syn keyword cConstant AG_NAMESPACES AG_SERIALIZATION AG_THREADS AG_TIMERS
  syn keyword cConstant AG_TYPE_SAFETY AG_UNICODE AG_USER AG_VERBOSITY
  syn keyword cConstant AG_WIDGETS AG_WM_HINTS
  " core/ag_string.h
  syn keyword cType AG_NewlineFormat AG_FmtString AG_FmtExtension
  syn keyword cConstant AG_STRING_BUFFERS_MAX AG_STRING_POINTERS_MAX
  syn keyword cConstant AG_FMTSTRING_BUFFER_INIT AG_FMTSTRING_BUFFER_GROW
  syn keyword cConstant AG_NEWLINE_NATIVE AG_NEWLINE_LF AG_NEWLINE_CR_LF 
  syn keyword cConstant AG_NEWLINE_CR AG_NEWLINE_LF_CR AG_NEWLINE_ATA_CR 
  syn keyword cConstant AG_NEWLINE_EBCDIC AG_NEWLINE_LAST AG_NEWLINE_DOS 
  syn keyword cConstant AG_NEWLINE_UNIX
  " core/tbl.h
  syn keyword cType AG_Tbl AG_TblBucket
  syn keyword cConstant AG_TBL_DUPLICATES
  " core/text.h
  syn keyword cType AG_Language AG_Text AG_TextElement AG_TextEnt
  syn keyword cConstant AG_LANG_NONE AG_LANG_AA AG_LANG_AB AG_LANG_AF AG_LANG_AM
  syn keyword cConstant AG_LANG_AR AG_LANG_AS AG_LANG_AY AG_LANG_AZ AG_LANG_BA
  syn keyword cConstant AG_LANG_BE AG_LANG_BG AG_LANG_BH AG_LANG_BI AG_LANG_BN
  syn keyword cConstant AG_LANG_BO AG_LANG_BR AG_LANG_CA AG_LANG_CO AG_LANG_CS
  syn keyword cConstant AG_LANG_CY AG_LANG_DA AG_LANG_DE AG_LANG_DZ AG_LANG_EL
  syn keyword cConstant AG_LANG_EN AG_LANG_EO AG_LANG_ES AG_LANG_ET AG_LANG_EU
  syn keyword cConstant AG_LANG_FA AG_LANG_FI AG_LANG_FJ AG_LANG_FO AG_LANG_FR
  syn keyword cConstant AG_LANG_FY AG_LANG_GA AG_LANG_GD AG_LANG_GL AG_LANG_GN
  syn keyword cConstant AG_LANG_GU AG_LANG_HA AG_LANG_HE AG_LANG_HI AG_LANG_HR
  syn keyword cConstant AG_LANG_HU AG_LANG_HY AG_LANG_IA AG_LANG_ID AG_LANG_IE
  syn keyword cConstant AG_LANG_IK AG_LANG_IS AG_LANG_IT AG_LANG_IU AG_LANG_JA
  syn keyword cConstant AG_LANG_JW AG_LANG_KA AG_LANG_KK AG_LANG_KL AG_LANG_KM
  syn keyword cConstant AG_LANG_KN AG_LANG_KO AG_LANG_KS AG_LANG_KU AG_LANG_KY
  syn keyword cConstant AG_LANG_LA AG_LANG_LN AG_LANG_LO AG_LANG_LT AG_LANG_LV
  syn keyword cConstant AG_LANG_MG AG_LANG_MI AG_LANG_MK AG_LANG_ML AG_LANG_MN
  syn keyword cConstant AG_LANG_MO AG_LANG_MR AG_LANG_MS AG_LANG_MT AG_LANG_MY
  syn keyword cConstant AG_LANG_NA AG_LANG_NE AG_LANG_NL AG_LANG_NO AG_LANG_OC
  syn keyword cConstant AG_LANG_OM AG_LANG_OR AG_LANG_PA AG_LANG_PL AG_LANG_PS
  syn keyword cConstant AG_LANG_PT AG_LANG_QU AG_LANG_RM AG_LANG_RN AG_LANG_RO
  syn keyword cConstant AG_LANG_RU AG_LANG_RW AG_LANG_SA AG_LANG_SD AG_LANG_SG
  syn keyword cConstant AG_LANG_SH AG_LANG_SI AG_LANG_SK AG_LANG_SL AG_LANG_SM
  syn keyword cConstant AG_LANG_SN AG_LANG_SO AG_LANG_SQ AG_LANG_SR AG_LANG_SS
  syn keyword cConstant AG_LANG_ST AG_LANG_SU AG_LANG_SV AG_LANG_SW AG_LANG_TA
  syn keyword cConstant AG_LANG_TE AG_LANG_TG AG_LANG_TH AG_LANG_TI AG_LANG_TK
  syn keyword cConstant AG_LANG_TL AG_LANG_TN AG_LANG_TO AG_LANG_TR AG_LANG_TS
  syn keyword cConstant AG_LANG_TT AG_LANG_TW AG_LANG_UG AG_LANG_UK AG_LANG_UR
  syn keyword cConstant AG_LANG_UZ AG_LANG_VI AG_LANG_VO AG_LANG_WO AG_LANG_XH
  syn keyword cConstant AG_LANG_YI AG_LANG_YO AG_LANG_ZA AG_LANG_ZH AG_LANG_ZU
  syn keyword cConstant AG_LANG_LAST AG_TEXT_SAVED_FLAGS
  " core/threads.h
  syn keyword cType AG_Mutex AG_MutexAttr AG_Thread AG_Cond AG_ThreadKey
  syn keyword cConstant AG_MUTEX_INITIALIZER
  " core/types.h
  syn keyword cType AG_Size AG_Offset AG_Char Uchar Uint Ulong
  syn keyword cConstant AG_MODEL AG_SMALL AG_MEDIUM AG_LARGE AG_HAVE_64BIT 
  syn keyword cConstant AG_HAVE_FLOAT AG_CHAR_MAX AG_SIZE_MAX AG_OFFS_MAX
  syn keyword cConstant AG_SIZE_PADDING AG_OFFSET_PADDING AG_CHAR_PADDING
  " core/user.h
  syn keyword cType AG_User AG_UserOps AG_UserList
  syn keyword cConstant AG_USER_NAME_MAX AG_USER_NO_ACCOUNT
  " core/variable.h
  syn keyword cType AG_Variable AG_VariableType AG_VariableTypeInfo
  syn keyword cType AG_VoidFn AG_UintFn AG_IntFn AG_Uint8Fn AG_Sint8Fn 
  syn keyword cType AG_Uint16Fn AG_Sint16Fn AG_Uint32Fn AG_Sint32Fn 
  syn keyword cType AG_Uint64Fn AG_Sint64Fn AG_FloatFn AG_DoubleFn AG_LongDoubleFn 
  syn keyword cType AG_StringFn AG_LongFn AG_UlongFn AG_PointerFn AG_ConstPointerFn
  syn keyword cConstant AG_VARIABLE_NULL AG_VARIABLE_UINT AG_VARIABLE_P_UINT
  syn keyword cConstant AG_VARIABLE_INT AG_VARIABLE_P_INT AG_VARIABLE_ULONG
  syn keyword cConstant AG_VARIABLE_P_ULONG AG_VARIABLE_LONG AG_VARIABLE_P_LONG
  syn keyword cConstant AG_VARIABLE_UINT8 AG_VARIABLE_P_UINT8 AG_VARIABLE_SINT8 AG_VARIABLE_P_SINT8
  syn keyword cConstant AG_VARIABLE_UINT16 AG_VARIABLE_P_UINT16 AG_VARIABLE_SINT16 AG_VARIABLE_P_SINT16
  syn keyword cConstant AG_VARIABLE_UINT32 AG_VARIABLE_P_UINT32 AG_VARIABLE_SINT32 AG_VARIABLE_P_SINT32
  syn keyword cConstant AG_VARIABLE_UINT64 AG_VARIABLE_P_UINT64 AG_VARIABLE_SINT64 AG_VARIABLE_P_SINT64
  syn keyword cConstant AG_VARIABLE_FLOAT AG_VARIABLE_P_FLOAT AG_VARIABLE_DOUBLE AG_VARIABLE_P_DOUBLE
  syn keyword cConstant AG_VARIABLE_STRING AG_VARIABLE_P_STRING AG_VARIABLE_POINTER AG_VARIABLE_P_POINTER
  syn keyword cConstant AG_VARIABLE_P_FLAG AG_VARIABLE_P_FLAG8 AG_VARIABLE_P_FLAG16 AG_VARIABLE_P_FLAG32
  syn keyword cConstant AG_VARIABLE_P_OBJECT AG_VARIABLE_P_VARIABLE
  syn keyword cConstant AG_VARIABLE_FUNCTION AG_VARIABLE_TYPE_LAST AG_VARIABLE_BOOL
  syn keyword cConstant AG_VARIABLE_NAME_MAX AG_VARIABLE_P_READONLY
  syn keyword cConstant AG_VARIABLE_P_FREE AG_VARIABLE_P_SENDER
  " core/vec.h
  syn keyword cConstant AG_VEC_HEAD
  " core/version.h
  syn keyword cType AG_AgarVersion
  syn keyword cConstant AGAR_MAJOR_VERSION AGAR_MINOR_VERSION AGAR_PATCHLEVEL
  " tests/agartest.h
  syn keyword cType AG_TestCase AG_TestInstance
endif
